/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.spring.validation;

import blue.hive.spring.validation.BHiveObjectError;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.Locale;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.util.StringUtils;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.multipart.MultipartFile;

@JsonPropertyOrder(value={"objectName", "field", "rejectedValue", "code", "message"})
public class BHiveFieldError
extends BHiveObjectError {
    private static final String MESSAGE_PREFIX_FOR_ERROR = "server.validate.";
    private static final String DOMAIN_PREFIX_FOR_ERROR = "domain.";
    protected String field;
    protected String fieldName;
    protected Object rejectedValue;

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public Object getRejectedValue() {
        if (this.rejectedValue instanceof MultipartFile) {
            return ((MultipartFile)this.rejectedValue).getOriginalFilename();
        }
        return this.rejectedValue;
    }

    public void setRejectedValue(Object rejectedValue) {
        this.rejectedValue = rejectedValue;
    }

    public BHiveFieldError(FieldError error) {
        super((ObjectError)error);
        this.field = error.getField();
        this.rejectedValue = error.getRejectedValue();
    }

    public BHiveFieldError(FieldError error, MessageSource messageSource) {
        super((ObjectError)error);
        this.field = error.getField();
        this.rejectedValue = error.getRejectedValue();
        this.resolveFieldName(messageSource);
        this.resolveMessage(error, messageSource, null);
    }

    public BHiveFieldError(FieldError error, MessageSource messageSource, String customFieldName) {
        super((ObjectError)error);
        this.field = error.getField();
        this.fieldName = customFieldName;
        this.rejectedValue = error.getRejectedValue();
        this.resolveFieldName(messageSource);
        this.resolveMessage(error, messageSource, customFieldName);
    }

    private void resolveFieldName(MessageSource messageSource) {
        try {
            Locale locale = LocaleContextHolder.getLocale();
            ArrayList<String> msgCode = new ArrayList<String>();
            msgCode.add((DOMAIN_PREFIX_FOR_ERROR + this.objectName + "." + this.field).toLowerCase());
            msgCode.add((DOMAIN_PREFIX_FOR_ERROR + this.field).toLowerCase());
            DefaultMessageSourceResolvable resolvable = new DefaultMessageSourceResolvable(msgCode.toArray(new String[msgCode.size()]), this.field);
            this.fieldName = messageSource.getMessage((MessageSourceResolvable)resolvable, locale);
        }
        catch (NoSuchMessageException e) {
            this.fieldName = this.field;
        }
    }

    private void resolveMessage(FieldError fieldError, MessageSource messageSource, String customFieldName) {
        try {
            Locale locale = LocaleContextHolder.getLocale();
            DefaultMessageSourceResolvable resolvable = this.getPrefixAddedMessageResolvable((DefaultMessageSourceResolvable)fieldError, true, customFieldName);
            this.logger.debug("resolvable ====> {}", (Object)resolvable);
            this.message = messageSource.getMessage((MessageSourceResolvable)resolvable, locale);
        }
        catch (NoSuchMessageException e) {
            this.message = fieldError.getDefaultMessage();
        }
    }

    private DefaultMessageSourceResolvable getPrefixAddedMessageResolvable(DefaultMessageSourceResolvable fieldError, boolean toLowercase, String customFieldName) {
        String[] codes = this.addPrefixToStringArray(fieldError.getCodes(), MESSAGE_PREFIX_FOR_ERROR, toLowercase);
        Object[] arguments = this.addPrefixToMessageSourceResolvableArguments(fieldError.getArguments(), DOMAIN_PREFIX_FOR_ERROR, toLowercase, customFieldName);
        String defaultMessage = fieldError.getDefaultMessage();
        return new DefaultMessageSourceResolvable(codes, arguments, defaultMessage);
    }

    private Object[] addPrefixToMessageSourceResolvableArguments(Object[] arguments, String prefix, boolean toLowercase, String customFieldName) {
        if (prefix == null) {
            prefix = "";
        }
        if (!toLowercase && StringUtils.isEmpty((Object)prefix)) {
            return arguments;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object argument : arguments) {
            if (argument instanceof DefaultMessageSourceResolvable) {
                DefaultMessageSourceResolvable messageResolvable = (DefaultMessageSourceResolvable)argument;
                if (!StringUtils.isEmpty((Object)customFieldName) && messageResolvable.getDefaultMessage().equals(this.field)) {
                    result.add(customFieldName);
                    continue;
                }
                String[] innerCodes = this.addPrefixToStringArray(messageResolvable.getCodes(), prefix, toLowercase);
                Object[] innerArguments = messageResolvable.getArguments();
                String innerDefaultMessage = messageResolvable.getDefaultMessage();
                result.add(new DefaultMessageSourceResolvable(innerCodes, innerArguments, innerDefaultMessage));
                continue;
            }
            result.add(argument);
        }
        return result.toArray();
    }

    private String[] addPrefixToStringArray(String[] codes, String prefix, boolean toLowercase) {
        if (prefix == null) {
            prefix = "";
        }
        if (!toLowercase && StringUtils.isEmpty((Object)prefix)) {
            return codes;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String code : codes) {
            if (toLowercase) {
                code = code.toLowerCase();
            }
            result.add(prefix + code);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String toString() {
        return "BHiveFieldError [objectName=" + this.objectName + ", field=" + this.field + ", rejectedValue=" + this.rejectedValue + ", code=" + this.code + ", message=" + this.message + "]";
    }
}

