/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.spring.job;

import blue.hive.exception.BHiveConfigurationException;
import blue.hive.spring.core.task.BHiveIntervalCallable;
import blue.hive.spring.core.task.BHiveIntervalTask;
import blue.hive.spring.core.task.BHiveJobCallable;
import blue.hive.util.BHiveHostingUtil;
import blue.hive.util.anyframe.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.task.TaskExecutor;

public class BHiveBatchBeanJob
implements InitializingBean,
BHiveIntervalCallable {
    protected final Logger logger = LoggerFactory.getLogger(BHiveBatchBeanJob.class);
    protected String instanceNameToRunning;
    protected BHiveJobCallable batchBean;
    protected TaskExecutor taskExecutor;

    public BHiveBatchBeanJob(String instanceNameToRunning, BHiveJobCallable batchBean, TaskExecutor taskExecutor) {
        this.instanceNameToRunning = instanceNameToRunning;
        this.batchBean = batchBean;
        this.taskExecutor = taskExecutor;
    }

    public void afterPropertiesSet() {
        if (this.batchBean == null) {
            throw new BHiveConfigurationException("BHiveBatchBeanJob.batchBean is required");
        }
        if (this.taskExecutor == null) {
            throw new BHiveConfigurationException("BHiveBatchBeanJob.taskExecutor is required");
        }
    }

    @Override
    public void runIntervalProcessTask() {
        if (this.taskExecutor == null) {
            this.logger.debug("taskExecutor configuration required.");
            return;
        }
        String currentInstanceName = BHiveHostingUtil.getWasContainerName();
        if (!(StringUtil.isEmptyTrimmed(this.instanceNameToRunning) || currentInstanceName != null && this.instanceNameToRunning.equals(currentInstanceName))) {
            this.logger.trace("#### SKIP BATCH #### instanceNameToRunning:{}, currentInstanceName:{}", (Object)this.instanceNameToRunning, (Object)currentInstanceName);
            return;
        }
        this.logger.trace("#### START BATCH #### instanceNameToRunning:{}, currentInstanceName:{}", (Object)this.instanceNameToRunning, (Object)currentInstanceName);
        this.taskExecutor.execute((Runnable)new BHiveIntervalTask(this));
    }

    @Override
    public void doIntervalProcess() {
        this.batchBean.doIntervalProcess();
    }
}

