/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.spring.http.converter;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpOutputMessage;

public class MultipartHttpOutputMessage
implements HttpOutputMessage {
    private final OutputStream outputStream;
    private final HttpHeaders headers = new HttpHeaders();
    private boolean headersWritten = false;

    public MultipartHttpOutputMessage(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public HttpHeaders getHeaders() {
        return this.headersWritten ? HttpHeaders.readOnlyHttpHeaders((HttpHeaders)this.headers) : this.headers;
    }

    public OutputStream getBody() throws IOException {
        this.writeHeaders();
        return this.outputStream;
    }

    private void writeHeaders() throws IOException {
        if (!this.headersWritten) {
            for (Map.Entry entry : this.headers.entrySet()) {
                byte[] headerName = this.getAsciiBytes((String)entry.getKey());
                for (String headerValueString : (List)entry.getValue()) {
                    byte[] headerValue = this.getAsciiBytes(headerValueString);
                    this.outputStream.write(headerName);
                    this.outputStream.write(58);
                    this.outputStream.write(32);
                    this.outputStream.write(headerValue);
                    this.outputStream.write(13);
                    this.outputStream.write(10);
                }
            }
            this.outputStream.write(13);
            this.outputStream.write(10);
            this.headersWritten = true;
        }
    }

    private byte[] getAsciiBytes(String name) {
        try {
            return name.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

