/*
 * Decompiled with CFR 0.152.
 */
package be.quodlibet.boxable.image;

import be.quodlibet.boxable.utils.ImageUtils;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;

public class Image {
    private final BufferedImage image;
    private float width;
    private float height;
    private float[] dpi = new float[]{72.0f, 72.0f};

    public Image(BufferedImage image) {
        this.image = image;
        this.width = image.getWidth();
        this.height = image.getHeight();
    }

    public Image(BufferedImage image, float dpi) {
        this(image, dpi, dpi);
    }

    public Image(BufferedImage image, float dpiX, float dpiY) {
        this.image = image;
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.dpi[0] = dpiX;
        this.dpi[1] = dpiY;
        this.scaleImageFromPixelToPoints();
    }

    public void draw(PDDocument doc, PDPageContentStream stream, float x, float y) throws IOException {
        PDImageXObject imageXObject = LosslessFactory.createFromImage((PDDocument)doc, (BufferedImage)this.image);
        stream.drawImage(imageXObject, x, y - this.height, this.width, this.height);
    }

    public Image scale(float width) {
        return this.scaleByWidth(width);
    }

    public Image scaleByWidth(float width) {
        float factorWidth = width / this.width;
        return this.scale(width, this.height * factorWidth);
    }

    private void scaleImageFromPixelToPoints() {
        float dpiX = this.dpi[0];
        float dpiY = this.dpi[1];
        this.scale(this.getImageWidthInPoints(dpiX), this.getImageHeightInPoints(dpiY));
    }

    public Image scaleByHeight(float height) {
        float factorHeight = height / this.height;
        return this.scale(this.width * factorHeight, height);
    }

    public float getImageWidthInPoints(float dpiX) {
        return this.width * 72.0f / dpiX;
    }

    public float getImageHeightInPoints(float dpiY) {
        return this.height * 72.0f / dpiY;
    }

    public Image scale(float boundWidth, float boundHeight) {
        float[] imageDimension = ImageUtils.getScaledDimension(this.width, this.height, boundWidth, boundHeight);
        this.width = imageDimension[0];
        this.height = imageDimension[1];
        return this;
    }

    public float getHeight() {
        return this.height;
    }

    public float getWidth() {
        return this.width;
    }
}

