/*
 * Decompiled with CFR 0.152.
 */
package com.github.devilyaos;

import com.alibaba.druid.filter.Filter;
import com.alibaba.druid.filter.stat.StatFilter;
import com.alibaba.druid.wall.WallConfig;
import com.alibaba.druid.wall.WallFilter;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.devilyaos.GetParamsListener;
import com.jfinal.kit.PathKit;
import com.jfinal.plugin.activerecord.ActiveRecordPlugin;
import com.jfinal.plugin.activerecord.CaseInsensitiveContainerFactory;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.IContainerFactory;
import com.jfinal.plugin.activerecord.IDataSourceProvider;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.activerecord.dialect.Dialect;
import com.jfinal.plugin.activerecord.dialect.MysqlDialect;
import com.jfinal.plugin.druid.DruidPlugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.Template;
import org.beetl.core.resource.FileResourceLoader;
import org.joda.time.DateTime;

public class AutoGen {
    private static AutoGen instance = new AutoGen();
    private static JSONObject config;
    private DruidPlugin dp;
    private ActiveRecordPlugin arp;
    private FileResourceLoader resourceLoader;
    private Configuration cfg;
    private GroupTemplate gt;

    public static AutoGen use() {
        return instance;
    }

    public AutoGen init() throws IOException {
        this.init(PathKit.getRootClassPath() + "/defaultRule.json");
        return this;
    }

    public AutoGen init(String configPath) throws IOException {
        if (configPath == null || configPath.length() == 0) {
            configPath = PathKit.getRootClassPath() + "/defaultRule.json";
        }
        if ((config = this.getConfig(configPath)) == null) {
            throw new NullPointerException("No Config.");
        }
        JSONObject dataSourceConfig = config.getJSONObject("dataSource");
        this.dp = new DruidPlugin(dataSourceConfig.getString("url"), dataSourceConfig.getString("user"), dataSourceConfig.getString("pwd"));
        this.dp.addFilter((Filter)new StatFilter());
        WallFilter wall = new WallFilter();
        wall.setDbType("mysql");
        WallConfig wallConfig = new WallConfig();
        wallConfig.setFunctionCheck(false);
        wallConfig.setCreateTableAllow(true);
        wallConfig.setCommentAllow(true);
        wallConfig.setMultiStatementAllow(true);
        wall.setConfig(wallConfig);
        this.dp.addFilter((Filter)wall);
        this.arp = new ActiveRecordPlugin((IDataSourceProvider)this.dp);
        this.arp.setContainerFactory((IContainerFactory)new CaseInsensitiveContainerFactory(true));
        this.arp.setDialect((Dialect)new MysqlDialect());
        this.dp.start();
        this.arp.start();
        this.resourceLoader = new FileResourceLoader(config.getString("baseTemplatePath"), "utf-8");
        this.cfg = Configuration.defaultConfiguration();
        this.gt = new GroupTemplate((ResourceLoader)this.resourceLoader, this.cfg);
        System.out.println("-- init success .");
        return this;
    }

    public void create(GetParamsListener listener) throws IOException {
        JSONArray tables = config.getJSONArray("tables");
        JSONArray templates = config.getJSONArray("templates");
        StringBuffer columnLineStr = new StringBuffer("");
        int len = tables.size();
        for (int i = 0; i < len; ++i) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            JSONObject table = tables.getJSONObject(i);
            System.out.println(String.format("-- start generate %s files", table.getString("tableName")));
            params.put("author", config.getString("author"));
            params.put("now", DateTime.now().toString(config.getString("dateFormat")));
            params.put("tableName", table.getString("tableName"));
            params.put("tableComment", table.getString("tableComment"));
            params.put("tablePre", table.getString("tablePre"));
            params.putAll(listener.addParamsAboutTableInfo(table.getString("tableName"), table.getString("tablePre"), table.getString("tableComment")));
            List columnList = Db.find((String)String.format("show full columns from %s", table.getString("tableName")));
            for (Record record : columnList) {
                Map<String, Object> columnParams = listener.addParamsAboutColumn(record.getStr("Field"), record.getStr("Type"), record.getStr("Key"), record.getStr("Default"), record.getStr("Comment"));
                record.setColumns(columnParams);
            }
            params.put("columnList", columnList);
            params.putAll(listener.addParamsAboutOthers());
            int size = templates.size();
            for (int j = 0; j < size; ++j) {
                JSONObject tempObj = templates.getJSONObject(j);
                JSONObject template = new JSONObject();
                for (String key : tempObj.keySet()) {
                    if (tempObj.get((Object)key) instanceof JSONArray) {
                        template.put(key, tempObj.getJSONArray(key).get(i));
                        continue;
                    }
                    template.put(key, tempObj.get((Object)key));
                }
                params.putAll((Map<String, Object>)template);
                Template beetlTemplate = this.gt.getTemplate(template.getString("templateName"));
                beetlTemplate.binding(params);
                String text = beetlTemplate.render();
                String filePath = template.getString("filePath").replace("{fileName}", template.getString("fileName"));
                File genFile = new File(filePath);
                FileUtils.touch((File)genFile);
                FileUtils.write((File)genFile, (CharSequence)text, (Charset)Charset.forName("utf-8"));
                System.out.println(String.format("---- %s : %s Done!", table.getString("tableName"), template.getString("templateName")));
            }
            System.out.println(String.format("-- %s Stop Deal", table.getString("tableName")));
        }
        this.arp.stop();
        this.dp.stop();
        System.out.println("-- release successfully .");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject getConfig(String path) {
        BufferedReader reader = null;
        StringBuffer laststr = new StringBuffer("");
        try {
            FileInputStream fileInputStream = new FileInputStream(path);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
            reader = new BufferedReader(inputStreamReader);
            String tempString = null;
            while ((tempString = reader.readLine()) != null) {
                laststr.append(tempString);
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (laststr.length() > 0) {
            return JSON.parseObject((String)laststr.toString());
        }
        return null;
    }

    public static String transJdbcType2CodeType(String jdbcType) {
        if (jdbcType == null || jdbcType.length() == 0) {
            return "undefined";
        }
        if (jdbcType.indexOf("(") > 0) {
            jdbcType = jdbcType.substring(0, jdbcType.indexOf("("));
        }
        if (config.getJSONObject("columnType").containsKey((Object)jdbcType)) {
            return config.getJSONObject("columnType").getString(jdbcType);
        }
        return "undefined";
    }

    public static String transJdbcName2ParaName(String jdbcName) {
        String[] arr = jdbcName.split("_");
        if (arr == null || arr.length == 0) {
            return "undefined";
        }
        String paraName = arr[0];
        int len = arr.length;
        for (int i = 1; i < len; ++i) {
            paraName = paraName + AutoGen.upFirstLetter(arr[i]);
        }
        return paraName;
    }

    public static String upFirstLetter(String word) {
        return word.substring(0, 1).toUpperCase() + word.substring(1);
    }
}

