/*
 * Decompiled with CFR 0.152.
 */
package waffle.apache;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.connector.Response;
import org.slf4j.Logger;
import waffle.windows.auth.IWindowsAuthProvider;
import waffle.windows.auth.PrincipalFormat;
import waffle.windows.auth.impl.WindowsAuthProviderImpl;

abstract class WaffleAuthenticatorBase
extends AuthenticatorBase {
    private static final Set<String> SUPPORTED_PROTOCOLS = new LinkedHashSet<String>(Arrays.asList("Negotiate", "NTLM"));
    protected String info;
    protected Logger log;
    protected PrincipalFormat principalFormat = PrincipalFormat.FQN;
    protected PrincipalFormat roleFormat = PrincipalFormat.FQN;
    protected boolean allowGuestLogin = true;
    protected Set<String> protocols = SUPPORTED_PROTOCOLS;
    protected IWindowsAuthProvider auth = new WindowsAuthProviderImpl();

    WaffleAuthenticatorBase() {
    }

    public IWindowsAuthProvider getAuth() {
        return this.auth;
    }

    public void setAuth(IWindowsAuthProvider provider) {
        this.auth = provider;
    }

    public String getInfo() {
        return this.info;
    }

    public void setPrincipalFormat(String format) {
        this.principalFormat = PrincipalFormat.valueOf((String)format.toUpperCase(Locale.ENGLISH));
        this.log.debug("principal format: {}", (Object)this.principalFormat);
    }

    public PrincipalFormat getPrincipalFormat() {
        return this.principalFormat;
    }

    public void setRoleFormat(String format) {
        this.roleFormat = PrincipalFormat.valueOf((String)format.toUpperCase(Locale.ENGLISH));
        this.log.debug("role format: {}", (Object)this.roleFormat);
    }

    public PrincipalFormat getRoleFormat() {
        return this.roleFormat;
    }

    public boolean isAllowGuestLogin() {
        return this.allowGuestLogin;
    }

    public void setAllowGuestLogin(boolean value) {
        this.allowGuestLogin = value;
    }

    public void setProtocols(String value) {
        String[] protocolNames;
        this.protocols = new LinkedHashSet<String>();
        for (String protocolName : protocolNames = value.split(",")) {
            if ((protocolName = protocolName.trim()).isEmpty()) continue;
            this.log.debug("init protocol: {}", (Object)protocolName);
            if (SUPPORTED_PROTOCOLS.contains(protocolName)) {
                this.protocols.add(protocolName);
                continue;
            }
            this.log.error("unsupported protocol: {}", (Object)protocolName);
            throw new RuntimeException("Unsupported protocol: " + protocolName);
        }
    }

    protected void sendUnauthorized(Response response) {
        try {
            for (String protocol : this.protocols) {
                response.addHeader("WWW-Authenticate", protocol);
            }
            response.setHeader("Connection", "close");
            response.sendError(401);
            response.flushBuffer();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void sendError(Response response, int code) {
        try {
            response.sendError(code);
        }
        catch (IOException e) {
            this.log.error(e.getMessage());
            this.log.trace("{}", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

