/*
 * Decompiled with CFR 0.152.
 */
package waffle.apache;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.catalina.Realm;
import org.apache.catalina.realm.GenericPrincipal;
import waffle.windows.auth.IWindowsAccount;
import waffle.windows.auth.IWindowsIdentity;
import waffle.windows.auth.PrincipalFormat;
import waffle.windows.auth.WindowsAccount;

public class GenericWindowsPrincipal
extends GenericPrincipal {
    private byte[] sid;
    private String sidString;
    private Map<String, WindowsAccount> groups;

    public GenericWindowsPrincipal(IWindowsIdentity newWindowsIdentity, Realm newRealm, PrincipalFormat newPrincipalFormat, PrincipalFormat newRoleFormat) {
        super(newRealm, newWindowsIdentity.getFqn(), "", GenericWindowsPrincipal.getRoles(newWindowsIdentity, newPrincipalFormat, newRoleFormat));
        this.sid = newWindowsIdentity.getSid();
        this.sidString = newWindowsIdentity.getSidString();
        this.groups = GenericWindowsPrincipal.getGroups(newWindowsIdentity.getGroups());
    }

    private static List<String> getRoles(IWindowsIdentity windowsIdentity, PrincipalFormat principalFormat, PrincipalFormat roleFormat) {
        ArrayList<String> roles = new ArrayList<String>();
        roles.addAll(GenericWindowsPrincipal.getPrincipalNames(windowsIdentity, principalFormat));
        for (IWindowsAccount group : windowsIdentity.getGroups()) {
            roles.addAll(GenericWindowsPrincipal.getRoleNames(group, roleFormat));
        }
        return roles;
    }

    private static Map<String, WindowsAccount> getGroups(IWindowsAccount[] groups) {
        HashMap<String, WindowsAccount> groupMap = new HashMap<String, WindowsAccount>();
        for (IWindowsAccount group : groups) {
            groupMap.put(group.getFqn(), new WindowsAccount(group));
        }
        return groupMap;
    }

    public byte[] getSid() {
        return (byte[])this.sid.clone();
    }

    public String getSidString() {
        return this.sidString;
    }

    public Map<String, WindowsAccount> getGroups() {
        return this.groups;
    }

    private static List<String> getRoleNames(IWindowsAccount group, PrincipalFormat principalFormat) {
        ArrayList<String> principals = new ArrayList<String>();
        switch (principalFormat) {
            case FQN: {
                principals.add(group.getFqn());
                break;
            }
            case SID: {
                principals.add(group.getSidString());
                break;
            }
            case BOTH: {
                principals.add(group.getFqn());
                principals.add(group.getSidString());
                break;
            }
            case NONE: {
                break;
            }
        }
        return principals;
    }

    private static List<String> getPrincipalNames(IWindowsIdentity windowsIdentity, PrincipalFormat principalFormat) {
        ArrayList<String> principals = new ArrayList<String>();
        switch (principalFormat) {
            case FQN: {
                principals.add(windowsIdentity.getFqn());
                break;
            }
            case SID: {
                principals.add(windowsIdentity.getSidString());
                break;
            }
            case BOTH: {
                principals.add(windowsIdentity.getFqn());
                principals.add(windowsIdentity.getSidString());
                break;
            }
            case NONE: {
                break;
            }
        }
        return principals;
    }

    public String getRolesString() {
        return Joiner.on((String)", ").join((Object[])this.getRoles());
    }
}

