/*
 * Decompiled with CFR 0.152.
 */
package com.dpizarro.uipicker.library.picker;

import android.os.Parcel;
import android.os.Parcelable;
import com.dpizarro.uipicker.library.R;
import com.dpizarro.uipicker.library.blur.PickerUIBlur;
import java.util.List;

public class PickerUISettings
implements Parcelable {
    public static final Parcelable.Creator<PickerUISettings> CREATOR = new Parcelable.Creator<PickerUISettings>(){

        public PickerUISettings createFromParcel(Parcel source) {
            return new PickerUISettings(source);
        }

        public PickerUISettings[] newArray(int size) {
            return new PickerUISettings[size];
        }
    };
    public static boolean DEFAULT_AUTO_DISMISS = true;
    public static boolean DEFAULT_ITEMS_CLICKABLES = true;
    private List<String> mItems;
    private int mColorTextCenter;
    private int mColorTextNoCenter;
    private int mBackgroundColor;
    private int mLinesColor;
    private boolean mAutoDismiss;
    private boolean mItemsClickables;
    private float mBlurDownScaleFactor;
    private int mBlurRadius;
    private int mBlurFilterColor;
    private boolean mUseBlur;
    private boolean mUseBlurRenderscript;

    private PickerUISettings(Builder builder) {
        this.setItems(builder.mItems);
        this.setColorTextCenter(builder.mColorTextCenter);
        this.setColorTextNoCenter(builder.mColorTextNoCenter);
        this.setBackgroundColor(builder.mBackgroundColor);
        this.setLinesColor(builder.mLinesColor);
        this.setItemsClickables(builder.mItemsClickables);
        this.setAutoDismiss(builder.mAutoDismiss);
        this.setUseBlur(builder.mUseBlur);
        this.setUseBlurRenderscript(builder.mUseBlurRenderscript);
        this.setBlurDownScaleFactor(builder.mDownScaleFactor);
        this.setBlurRadius(builder.mRadius);
        this.setBlurFilterColor(builder.mFilterColor);
    }

    private PickerUISettings(Parcel in) {
        in.readStringList(this.mItems);
        this.mColorTextCenter = in.readInt();
        this.mColorTextNoCenter = in.readInt();
        this.mBackgroundColor = in.readInt();
        this.mLinesColor = in.readInt();
        this.mAutoDismiss = in.readByte() != 0;
        this.mItemsClickables = in.readByte() != 0;
        this.mBlurDownScaleFactor = in.readFloat();
        this.mBlurRadius = in.readInt();
        this.mBlurFilterColor = in.readInt();
        this.mUseBlur = in.readByte() != 0;
        this.mUseBlurRenderscript = in.readByte() != 0;
    }

    public List<String> getItems() {
        return this.mItems;
    }

    void setItems(List<String> items) {
        this.mItems = items;
    }

    public int getColorTextCenter() {
        return this.mColorTextCenter;
    }

    void setColorTextCenter(int colorTextCenter) {
        this.mColorTextCenter = colorTextCenter;
    }

    public int getColorTextNoCenter() {
        return this.mColorTextNoCenter;
    }

    void setColorTextNoCenter(int colorTextNoCenter) {
        this.mColorTextNoCenter = colorTextNoCenter;
    }

    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    void setBackgroundColor(int backgroundColor) {
        this.mBackgroundColor = backgroundColor;
    }

    public int getLinesColor() {
        return this.mLinesColor;
    }

    void setLinesColor(int linesColor) {
        this.mLinesColor = linesColor;
    }

    public boolean areItemsClickables() {
        return this.mItemsClickables;
    }

    void setItemsClickables(boolean itemsClickables) {
        this.mItemsClickables = itemsClickables;
    }

    public boolean isAutoDismiss() {
        return this.mAutoDismiss;
    }

    void setAutoDismiss(boolean autoDismiss) {
        this.mAutoDismiss = autoDismiss;
    }

    public boolean isUseBlur() {
        return this.mUseBlur;
    }

    void setUseBlur(boolean useBlur) {
        this.mUseBlur = useBlur;
    }

    public boolean isUseBlurRenderscript() {
        return this.mUseBlurRenderscript;
    }

    void setUseBlurRenderscript(boolean useBlurRenderscript) {
        this.mUseBlurRenderscript = useBlurRenderscript;
    }

    public float getBlurDownScaleFactor() {
        return this.mBlurDownScaleFactor;
    }

    void setBlurDownScaleFactor(float blurDownScaleFactor) {
        this.mBlurDownScaleFactor = blurDownScaleFactor;
    }

    public int getBlurRadius() {
        return this.mBlurRadius;
    }

    void setBlurRadius(int blurRadius) {
        this.mBlurRadius = blurRadius;
    }

    public int getBlurFilterColor() {
        return this.mBlurFilterColor;
    }

    void setBlurFilterColor(int blurFilterColor) {
        this.mBlurFilterColor = blurFilterColor;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeList(this.mItems);
        dest.writeInt(this.mColorTextCenter);
        dest.writeInt(this.mColorTextNoCenter);
        dest.writeInt(this.mBackgroundColor);
        dest.writeInt(this.mLinesColor);
        dest.writeByte(this.mAutoDismiss ? (byte)1 : 0);
        dest.writeByte(this.mItemsClickables ? (byte)1 : 0);
        dest.writeFloat(this.mBlurDownScaleFactor);
        dest.writeInt(this.mBlurRadius);
        dest.writeInt(this.mBlurFilterColor);
        dest.writeByte(this.mUseBlur ? (byte)1 : 0);
        dest.writeByte(this.mUseBlurRenderscript ? (byte)1 : 0);
    }

    public static final class Builder {
        private List<String> mItems;
        private int mColorTextCenter = R.color.text_center_pickerui;
        private int mColorTextNoCenter = R.color.text_no_center_pickerui;
        private int mBackgroundColor = R.color.background_panel_pickerui;
        private int mLinesColor = R.color.lines_panel_pickerui;
        private boolean mUseBlur = PickerUIBlur.DEFAULT_USE_BLUR;
        private boolean mUseBlurRenderscript = PickerUIBlur.DEFAULT_USE_BLUR_RENDERSCRIPT;
        private boolean mItemsClickables = DEFAULT_ITEMS_CLICKABLES;
        private float mDownScaleFactor = PickerUIBlur.DEFAULT_DOWNSCALE_FACTOR;
        private int mRadius = PickerUIBlur.DEFAULT_BLUR_RADIUS;
        private boolean mAutoDismiss = DEFAULT_AUTO_DISMISS;
        private int mFilterColor = -1;

        public Builder() {
        }

        private Builder(Builder builder) {
            this.mUseBlurRenderscript = builder.mUseBlurRenderscript;
            this.mUseBlur = builder.mUseBlur;
        }

        public Builder withItems(List<String> mItems) {
            this.mItems = mItems;
            return this;
        }

        public Builder withColorTextCenter(int mColorTextCenter) {
            this.mColorTextCenter = mColorTextCenter;
            return this;
        }

        public Builder withColorTextNoCenter(int mColorTextNoCenter) {
            this.mColorTextNoCenter = mColorTextNoCenter;
            return this;
        }

        public Builder withBackgroundColor(int mBackgroundColor) {
            this.mBackgroundColor = mBackgroundColor;
            return this;
        }

        public Builder withLinesColor(int mLinesColor) {
            this.mLinesColor = mLinesColor;
            return this;
        }

        public Builder withItemsClickables(boolean mItemsClickables) {
            this.mItemsClickables = mItemsClickables;
            return this;
        }

        public Builder withAutoDismiss(boolean mAutoDismiss) {
            this.mAutoDismiss = mAutoDismiss;
            return this;
        }

        public Builder withBlurDownScaleFactor(float mDownScaleFactor) {
            this.mDownScaleFactor = mDownScaleFactor;
            return this;
        }

        public Builder withBlurRadius(int mRadius) {
            this.mRadius = mRadius;
            return this;
        }

        public Builder withBlurFilterColor(int mFilterColor) {
            this.mFilterColor = mFilterColor;
            return this;
        }

        public Builder withUseBlurRenderscript(boolean mUseBlurRenderscript) {
            this.mUseBlurRenderscript = mUseBlurRenderscript;
            return this;
        }

        public Builder withUseBlur(boolean mUseBlur) {
            this.mUseBlur = mUseBlur;
            return this;
        }

        public PickerUISettings build() {
            return new PickerUISettings(this);
        }
    }
}

