/*
 * Decompiled with CFR 0.152.
 */
package com.dpizarro.uipicker.library.blur;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.AsyncTask;
import android.view.View;
import com.dpizarro.uipicker.library.blur.Blur;
import com.dpizarro.uipicker.library.blur.PickerUIBlurHelper;

public class PickerUIBlurTask
extends AsyncTask<Void, Void, Bitmap> {
    private final PickerUIBlurHelper.BlurFinishedListener mBlurFinishedListener;
    private State mState = State.READY;
    private Bitmap mBitmapDownscaled;
    private int mBlurRadius;
    private Activity activity;
    private boolean useRenderScript;

    public PickerUIBlurTask(Activity a, int radius, PickerUIBlurHelper.BlurFinishedListener blurFinishedListener, boolean useRenderScript) {
        this.activity = a;
        this.mBlurRadius = radius < 1 ? 1 : radius;
        this.mBlurFinishedListener = blurFinishedListener;
        this.useRenderScript = useRenderScript;
    }

    protected void onPreExecute() {
        super.onPreExecute();
        if (this.mState.equals((Object)State.READY)) {
            this.mState = State.EXECUTING;
            View snapshotView = this.activity.getWindow().getDecorView().findViewById(0x1020002);
            Bitmap bitmapDecorView = PickerUIBlurHelper.loadBitmapFromView(snapshotView);
            if (bitmapDecorView != null) {
                this.mBitmapDownscaled = PickerUIBlurHelper.downscaleBitmap(bitmapDecorView);
            }
        } else {
            this.cancel(true);
        }
    }

    protected Bitmap doInBackground(Void ... params) {
        if (this.mState.equals((Object)State.EXECUTING) && this.mBitmapDownscaled != null) {
            return Blur.apply((Context)this.activity, this.mBitmapDownscaled, this.mBlurRadius, this.useRenderScript);
        }
        return null;
    }

    protected void onPostExecute(Bitmap blurredBitmap) {
        super.onPostExecute((Object)blurredBitmap);
        this.activity = null;
        if (this.mBlurFinishedListener == null) {
            throw new IllegalStateException("You must assign a valid BlurFinishedListener first!");
        }
        this.mBlurFinishedListener.onBlurFinished(blurredBitmap);
        this.mState = State.READY;
    }

    private static enum State {
        READY,
        EXECUTING;

    }
}

