/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.helper;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.subethamail.smtp.MessageContext;
import org.subethamail.smtp.MessageHandler;
import org.subethamail.smtp.MessageHandlerFactory;
import org.subethamail.smtp.RejectException;
import org.subethamail.smtp.TooMuchDataException;
import org.subethamail.smtp.helper.SmarterMessageListener;
import org.subethamail.smtp.internal.io.DeferredFileOutputStream;

public class SmarterMessageListenerAdapter
implements MessageHandlerFactory {
    private static final int DEFAULT_DATA_DEFERRED_SIZE = 0x500000;
    private final Collection<SmarterMessageListener> listeners;
    private final int dataDeferredSize;

    public SmarterMessageListenerAdapter(SmarterMessageListener listener) {
        this(Collections.singleton(listener), 0x500000);
    }

    public SmarterMessageListenerAdapter(Collection<SmarterMessageListener> listeners) {
        this(listeners, 0x500000);
    }

    public SmarterMessageListenerAdapter(Collection<SmarterMessageListener> listeners, int dataDeferredSize) {
        this.listeners = listeners;
        this.dataDeferredSize = dataDeferredSize;
    }

    @Override
    public MessageHandler create(MessageContext ctx) {
        return new Handler();
    }

    class Handler
    implements MessageHandler {
        String from;
        List<SmarterMessageListener.Receiver> deliveries = new ArrayList<SmarterMessageListener.Receiver>();

        Handler() {
        }

        @Override
        public void from(String from) throws RejectException {
            this.from = from;
        }

        @Override
        public void recipient(String recipient) throws RejectException {
            for (SmarterMessageListener listener : SmarterMessageListenerAdapter.this.listeners) {
                SmarterMessageListener.Receiver rec = listener.accept(this.from, recipient);
                if (rec == null) continue;
                this.deliveries.add(rec);
            }
            if (this.deliveries.isEmpty()) {
                throw new RejectException(553, "<" + recipient + "> address unknown.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String data(InputStream data) throws TooMuchDataException, IOException {
            if (this.deliveries.size() == 1) {
                this.deliveries.get(0).deliver(data);
            } else {
                try (DeferredFileOutputStream dfos = new DeferredFileOutputStream(SmarterMessageListenerAdapter.this.dataDeferredSize);){
                    int value;
                    while ((value = data.read()) >= 0) {
                        dfos.write(value);
                    }
                    for (SmarterMessageListener.Receiver rec : this.deliveries) {
                        rec.deliver(dfos.getInputStream());
                    }
                }
            }
            return null;
        }

        @Override
        public void done() {
            for (SmarterMessageListener.Receiver rec : this.deliveries) {
                rec.done();
            }
        }
    }
}

