/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree.fbs;

import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.rtree.Context;
import com.github.davidmoten.rtree.Entries;
import com.github.davidmoten.rtree.Entry;
import com.github.davidmoten.rtree.Node;
import com.github.davidmoten.rtree.NonLeaf;
import com.github.davidmoten.rtree.fbs.FlatBuffersHelper;
import com.github.davidmoten.rtree.fbs.LeafFlatBuffers;
import com.github.davidmoten.rtree.fbs.generated.Box_;
import com.github.davidmoten.rtree.fbs.generated.Entry_;
import com.github.davidmoten.rtree.fbs.generated.Geometry_;
import com.github.davidmoten.rtree.fbs.generated.Node_;
import com.github.davidmoten.rtree.geometry.Geometries;
import com.github.davidmoten.rtree.geometry.Geometry;
import com.github.davidmoten.rtree.internal.NodeAndEntries;
import com.github.davidmoten.rtree.internal.NonLeafHelper;
import java.util.ArrayList;
import java.util.List;
import rx.Subscriber;
import rx.functions.Func1;

final class NonLeafFlatBuffers<T, S extends Geometry>
implements NonLeaf<T, S> {
    private final Node_ node;
    private final Context<T, S> context;
    private final Func1<byte[], T> deserializer;

    NonLeafFlatBuffers(Node_ node, Context<T, S> context, Func1<byte[], T> deserializer) {
        Preconditions.checkNotNull((Object)((Object)node));
        this.node = node;
        this.context = context;
        this.deserializer = deserializer;
    }

    @Override
    public List<Node<T, S>> add(Entry<? extends T, ? extends S> entry) {
        return NonLeafHelper.add(entry, this);
    }

    @Override
    public NodeAndEntries<T, S> delete(Entry<? extends T, ? extends S> entry, boolean all) {
        return NonLeafHelper.delete(entry, all, this);
    }

    @Override
    public void searchWithoutBackpressure(Func1<? super Geometry, Boolean> criterion, Subscriber<? super Entry<T, S>> subscriber) {
        NonLeafFlatBuffers.searchWithoutBackpressure(this.node, criterion, subscriber, this.deserializer, new Entry_(), new Geometry_(), new Box_());
    }

    private static <T, S extends Geometry> void searchWithoutBackpressure(Node_ node, Func1<? super Geometry, Boolean> criterion, Subscriber<? super Entry<T, S>> subscriber, Func1<byte[], T> deserializer, Entry_ entry, Geometry_ geometry, Box_ box) {
        node.mbb(box);
        if (!((Boolean)criterion.call((Object)Geometries.rectangle(box.minX(), box.minY(), box.maxX(), box.maxY()))).booleanValue()) {
            return;
        }
        int numChildren = node.childrenLength();
        Node_ child = new Node_();
        if (numChildren > 0) {
            for (int i = 0; i < numChildren; ++i) {
                if (subscriber.isUnsubscribed()) {
                    return;
                }
                node.children(child, i);
                NonLeafFlatBuffers.searchWithoutBackpressure(child, criterion, subscriber, deserializer, entry, geometry, box);
            }
        } else {
            int numEntries = node.entriesLength();
            for (int i = 0; i < numEntries; ++i) {
                if (subscriber.isUnsubscribed()) {
                    return;
                }
                node.entries(entry, i);
                entry.geometry(geometry);
                Object g = FlatBuffersHelper.toGeometry(geometry);
                if (!((Boolean)criterion.call(g)).booleanValue()) continue;
                T t = FlatBuffersHelper.parseObject(deserializer, entry);
                Entry ent = Entries.entry(t, g);
                subscriber.onNext(ent);
            }
        }
    }

    private List<Node<T, S>> createChildren() {
        ArrayList<Node<T, S>> children = new ArrayList<Node<T, S>>(this.node.childrenLength());
        int numChildren = this.node.childrenLength();
        for (int i = 0; i < numChildren; ++i) {
            Node_ child = this.node.children(i);
            if (child.childrenLength() > 0) {
                children.add(new NonLeafFlatBuffers<T, S>(child, this.context, this.deserializer));
                continue;
            }
            children.add(new LeafFlatBuffers<T, S>(child, this.context, this.deserializer));
        }
        return children;
    }

    @Override
    public int count() {
        return this.node.childrenLength();
    }

    @Override
    public Context<T, S> context() {
        return this.context;
    }

    @Override
    public Geometry geometry() {
        return FlatBuffersHelper.createBox(this.node.mbb());
    }

    @Override
    public Node<T, S> child(int i) {
        Node_ child = this.node.children(i);
        if (child.childrenLength() > 0) {
            return new NonLeafFlatBuffers<T, S>(child, this.context, this.deserializer);
        }
        return new LeafFlatBuffers<T, S>(child, this.context, this.deserializer);
    }

    @Override
    public List<Node<T, S>> children() {
        return this.createChildren();
    }

    public String toString() {
        return "Node [" + (this.node.childrenLength() > 0 ? "NonLeaf" : "Leaf") + "," + FlatBuffersHelper.createBox(this.node.mbb()).toString() + "]";
    }
}

