/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree;

import com.github.davidmoten.rtree.Context;
import com.github.davidmoten.rtree.Entry;
import com.github.davidmoten.rtree.Node;
import com.github.davidmoten.rtree.NodeAndEntries;
import com.github.davidmoten.rtree.Util;
import com.github.davidmoten.rtree.geometry.Geometry;
import com.github.davidmoten.rtree.geometry.ListPair;
import com.github.davidmoten.rtree.geometry.Rectangle;
import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import rx.Subscriber;
import rx.functions.Func1;

final class Leaf<T, S extends Geometry>
implements Node<T, S> {
    private final List<Entry<T, S>> entries;
    private final Rectangle mbr;
    private final Context context;

    Leaf(List<Entry<T, S>> entries, Context context) {
        this.entries = entries;
        this.context = context;
        this.mbr = Util.mbr(entries);
    }

    @Override
    public Geometry geometry() {
        return this.mbr;
    }

    List<Entry<T, S>> entries() {
        return this.entries;
    }

    @Override
    public void search(Func1<? super Geometry, Boolean> condition, Subscriber<? super Entry<T, S>> subscriber) {
        if (!((Boolean)condition.call((Object)this.geometry().mbr())).booleanValue()) {
            return;
        }
        for (Entry<T, S> entry : this.entries) {
            if (subscriber.isUnsubscribed()) {
                return;
            }
            if (!((Boolean)condition.call(entry.geometry())).booleanValue()) continue;
            subscriber.onNext(entry);
        }
    }

    @Override
    public int count() {
        return this.entries.size();
    }

    @Override
    public List<Node<T, S>> add(Entry<? extends T, ? extends S> entry) {
        List<Entry<T, S>> entries2 = Util.add(this.entries, entry);
        if (entries2.size() <= this.context.maxChildren()) {
            return Collections.singletonList(new Leaf<T, S>(entries2, this.context));
        }
        ListPair<Entry<T, S>> pair = this.context.splitter().split(entries2, this.context.minChildren());
        return this.makeLeaves(pair);
    }

    private List<Node<T, S>> makeLeaves(ListPair<Entry<T, S>> pair) {
        ArrayList<Node<T, S>> list = new ArrayList<Node<T, S>>();
        list.add(new Leaf<T, S>(pair.group1().list(), this.context));
        list.add(new Leaf<T, S>(pair.group2().list(), this.context));
        return list;
    }

    @Override
    public NodeAndEntries<T, S> delete(Entry<? extends T, ? extends S> entry, boolean all) {
        if (!this.entries.contains(entry)) {
            return new NodeAndEntries(Optional.of((Object)this), Collections.emptyList(), 0);
        }
        ArrayList<Entry<T, S>> entries2 = new ArrayList<Entry<T, S>>(this.entries);
        entries2.remove(entry);
        int numDeleted = 1;
        while (all && entries2.remove(entry)) {
            ++numDeleted;
        }
        if (entries2.size() >= this.context.minChildren()) {
            Leaf<T, S> node = new Leaf<T, S>(entries2, this.context);
            return new NodeAndEntries(Optional.of(node), Collections.emptyList(), numDeleted);
        }
        return new NodeAndEntries<T, S>(Optional.absent(), entries2, numDeleted);
    }
}

