/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree;

import com.github.davidmoten.rtree.Entry;
import com.github.davidmoten.rtree.Leaf;
import com.github.davidmoten.rtree.Node;
import com.github.davidmoten.rtree.NodePosition;
import com.github.davidmoten.rtree.NonLeaf;
import com.github.davidmoten.rtree.geometry.Geometry;
import com.github.davidmoten.util.ImmutableStack;
import rx.Subscriber;
import rx.functions.Func1;

final class Backpressure {
    private Backpressure() {
    }

    static <T> ImmutableStack<NodePosition<T>> search(Func1<? super Geometry, Boolean> condition, Subscriber<? super Entry<T>> subscriber, ImmutableStack<NodePosition<T>> stack, long request) {
        if (stack.isEmpty()) {
            return stack;
        }
        while (true) {
            long nextRequest;
            NodePosition<T> np = stack.peek();
            if (subscriber.isUnsubscribed()) {
                return ImmutableStack.empty();
            }
            if (request == 0L) {
                return stack;
            }
            if (np.position() == np.node().count()) {
                ImmutableStack<NodePosition<T>> stack2 = stack.pop();
                if (stack2.isEmpty()) {
                    return stack2;
                }
                NodePosition<T> previous = stack2.peek();
                stack = stack2.pop().push(previous.nextPosition());
                continue;
            }
            if (np.node() instanceof NonLeaf) {
                Node child = ((NonLeaf)np.node()).children().get(np.position());
                if (((Boolean)condition.call((Object)child.geometry())).booleanValue()) {
                    stack = stack.push(new NodePosition(child, 0));
                    continue;
                }
                stack = stack.pop().push(np.nextPosition());
                continue;
            }
            Entry entry = ((Leaf)np.node()).entries().get(np.position());
            if (((Boolean)condition.call((Object)entry.geometry())).booleanValue()) {
                subscriber.onNext(entry);
                nextRequest = request - 1L;
            } else {
                nextRequest = request;
            }
            stack = stack.pop().push(np.nextPosition());
            request = nextRequest;
        }
    }
}

