/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree;

import com.github.davidmoten.rtree.Context;
import com.github.davidmoten.rtree.Entry;
import com.github.davidmoten.rtree.Leaf;
import com.github.davidmoten.rtree.Node;
import com.github.davidmoten.rtree.NonLeaf;
import com.github.davidmoten.rtree.OnSubscribeSearch;
import com.github.davidmoten.rtree.QuadraticSplitter;
import com.github.davidmoten.rtree.Selector;
import com.github.davidmoten.rtree.SelectorMinimalAreaIncrease;
import com.github.davidmoten.rtree.Splitter;
import com.github.davidmoten.rtree.Visualizer;
import com.github.davidmoten.rtree.geometry.Geometry;
import com.github.davidmoten.rtree.geometry.Rectangle;
import com.github.davidmoten.rx.operators.OperatorBoundedPriorityQueue;
import com.github.davidmoten.util.ImmutableStack;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.Comparator;
import rx.Observable;
import rx.functions.Func1;

public class RTree<R> {
    private final ImmutableStack<NonLeaf<R>> emptyStack = ImmutableStack.empty();
    private final Optional<Node<R>> root;
    private final Context context;
    public static final int MAX_CHILDREN_DEFAULT = 32;
    public static final Func1<Geometry, Boolean> ALWAYS_TRUE = new Func1<Geometry, Boolean>(){

        public Boolean call(Geometry rectangle) {
            return true;
        }
    };

    private RTree(Optional<Node<R>> root, Context context) {
        this.root = root;
        this.context = context;
    }

    private RTree(Node<R> root, Context context) {
        this(Optional.of(root), context);
    }

    public static <T> RTree<T> create() {
        return new Builder().create();
    }

    public int calculateDepth() {
        return RTree.calculateDepth(this.root);
    }

    private static <R> int calculateDepth(Optional<Node<R>> root) {
        if (!root.isPresent()) {
            return 0;
        }
        return RTree.calculateDepth((Node)root.get(), 0);
    }

    private static <R> int calculateDepth(Node<R> node, int depth) {
        if (node instanceof Leaf) {
            return depth + 1;
        }
        return RTree.calculateDepth(((NonLeaf)node).children().get(0), depth + 1);
    }

    public static Builder minChildren(int minChildren) {
        return new Builder().minChildren(minChildren);
    }

    public static Builder maxChildren(int maxChildren) {
        return new Builder().maxChildren(maxChildren);
    }

    public static Builder splitter(Splitter splitter) {
        return new Builder().splitter(splitter);
    }

    public static Builder selector(Selector selector) {
        return new Builder().selector(selector);
    }

    public RTree<R> add(Entry<R> entry) {
        if (this.root.isPresent()) {
            return new RTree<R>(((Node)this.root.get()).add(entry, this.emptyStack), this.context);
        }
        return new RTree(new Leaf(Lists.newArrayList((Object[])new Entry[]{entry}), this.context), this.context);
    }

    public RTree<R> add(R value, Geometry geometry) {
        return this.add(Entry.entry(value, geometry));
    }

    public RTree<R> delete(R value, Geometry geometry) {
        return this.delete(Entry.entry(value, geometry));
    }

    public RTree<R> delete(Entry<R> entry) {
        if (this.root.isPresent()) {
            Optional<Node<R>> newRoot = ((Node)this.root.get()).delete(entry, this.emptyStack);
            if (newRoot.equals(this.root)) {
                return this;
            }
            return new RTree<R>(newRoot, this.context);
        }
        return this;
    }

    public Observable<Entry<R>> search(Func1<? super Geometry, Boolean> condition) {
        if (this.root.isPresent()) {
            return Observable.create(new OnSubscribeSearch((Node)this.root.get(), condition));
        }
        return Observable.empty();
    }

    public static final <S> Comparator<Entry<S>> ascendingDistance(final Rectangle r) {
        return new Comparator<Entry<S>>(){

            @Override
            public int compare(Entry<S> e1, Entry<S> e2) {
                return Double.valueOf(e1.geometry().distance(r)).compareTo(e2.geometry().distance(r));
            }
        };
    }

    public static Func1<Geometry, Boolean> intersects(final Rectangle r) {
        return new Func1<Geometry, Boolean>(){

            public Boolean call(Geometry g) {
                return g.distance(r) == 0.0;
            }
        };
    }

    public Observable<Entry<R>> search(Rectangle r) {
        return this.search(RTree.intersects(r));
    }

    public Observable<Entry<R>> search(final Rectangle r, final double maxDistance) {
        return this.search((Func1<Geometry, Boolean>)new Func1<Geometry, Boolean>(){

            public Boolean call(Geometry g) {
                return g.distance(r) < maxDistance;
            }
        });
    }

    public Observable<Entry<R>> nearest(Rectangle r, double maxDistance, int maxCount) {
        return this.search(r, maxDistance).lift(new OperatorBoundedPriorityQueue(maxCount, RTree.ascendingDistance(r)));
    }

    public Observable<Entry<R>> entries() {
        return this.search(ALWAYS_TRUE);
    }

    public Visualizer visualize(int width, int height, Rectangle view) {
        return new Visualizer(this, width, height, view);
    }

    Optional<Node<R>> root() {
        return this.root;
    }

    public boolean isEmpty() {
        return !this.root.isPresent();
    }

    public static class Builder {
        private int maxChildren = 32;
        private Optional<Integer> minChildren = Optional.absent();
        private Splitter splitter = new QuadraticSplitter();
        private Selector selector = new SelectorMinimalAreaIncrease();

        private Builder() {
        }

        public Builder minChildren(int minChildren) {
            this.minChildren = Optional.of((Object)minChildren);
            return this;
        }

        public Builder maxChildren(int maxChildren) {
            this.maxChildren = maxChildren;
            return this;
        }

        public Builder splitter(Splitter splitter) {
            this.splitter = splitter;
            return this;
        }

        public <T> Builder selector(Selector selector) {
            this.selector = selector;
            return this;
        }

        public <S> RTree<S> create() {
            if (!this.minChildren.isPresent()) {
                this.minChildren = Optional.of((Object)(this.maxChildren / 2));
            }
            return new RTree(Optional.absent(), new Context((Integer)this.minChildren.get(), this.maxChildren, this.selector, this.splitter));
        }
    }
}

