/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.grumpy.wms;

import com.github.davidmoten.grumpy.core.Position;
import com.github.davidmoten.grumpy.projection.FeatureUtil;
import com.github.davidmoten.grumpy.projection.Projector;
import com.github.davidmoten.grumpy.projection.ProjectorBounds;
import com.github.davidmoten.grumpy.projection.ProjectorTarget;
import com.github.davidmoten.grumpy.wms.WmsRequest;
import java.awt.Color;
import java.awt.Rectangle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.renderer.lite.RendererUtilities;

public class WmsUtil {
    public static List<Color> getColorFromStyles(List<String> styles) {
        ArrayList<Color> colors = new ArrayList<Color>();
        for (String style : styles) {
            try {
                Field field = Color.class.getField(style);
                Color color = (Color)field.get(null);
                colors.add(color);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        return colors;
    }

    public static Projector getProjector(WmsRequest request) {
        ProjectorTarget target = new ProjectorTarget(request.getWidth(), request.getHeight());
        return new Projector(request.getBounds(), target);
    }

    public static double getScale(WmsRequest request) {
        ProjectorBounds b = request.getBounds();
        ReferencedEnvelope envelope = new ReferencedEnvelope(b.getMinX(), b.getMaxX(), b.getMinY(), b.getMaxY(), FeatureUtil.getCrs((String)request.getCrs()));
        return RendererUtilities.calculateOGCScale((ReferencedEnvelope)envelope, (int)request.getWidth(), Collections.emptyMap());
    }

    public static Rectangle toTargetRectangle(Projector projector) {
        ProjectorTarget t = projector.getTarget();
        return new Rectangle(0, 0, t.getWidth(), t.getHeight());
    }

    public static List<Position> getBorder(Projector projector, Rectangle region) {
        ArrayList<Position> box = new ArrayList<Position>();
        box.add(projector.toPosition((double)region.x, (double)region.y));
        box.add(projector.toPosition((double)region.x, (double)(region.y + region.height)));
        box.add(projector.toPosition((double)(region.x + region.width), (double)(region.y + region.height)));
        box.add(projector.toPosition((double)(region.x + region.width), (double)region.y));
        box.add(projector.toPosition((double)region.x, (double)region.y));
        return box;
    }
}

