/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.grumpy.wms;

import com.github.davidmoten.grumpy.wms.ImageCache;
import com.github.davidmoten.grumpy.wms.ImageWriter;
import com.github.davidmoten.grumpy.wms.ImageWriterDefault;
import com.github.davidmoten.grumpy.wms.Layer;
import com.github.davidmoten.grumpy.wms.LayerManager;
import com.github.davidmoten.grumpy.wms.Layers;
import com.github.davidmoten.grumpy.wms.LayersBuilder;
import com.github.davidmoten.grumpy.wms.MissingMandatoryParameterException;
import com.github.davidmoten.grumpy.wms.UnknownParameterException;
import com.github.davidmoten.grumpy.wms.WmsGetCapabilitiesProvider;
import com.github.davidmoten.grumpy.wms.WmsGetCapabilitiesProviderFromClasspath;
import com.github.davidmoten.grumpy.wms.WmsRequest;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WmsServletRequestProcessor {
    private static Logger log = LoggerFactory.getLogger(WmsServletRequestProcessor.class);
    private static final String REQUEST_GET_MAP = "GetMap";
    private static final String PARAMETER_REQUEST = "REQUEST";
    private static final Object REQUEST_GET_CAPABILITIES = "GetCapabilities";
    private static final Object REQUEST_GET_FEATURE_INFO = "GetFeatureInfo";
    private final WmsGetCapabilitiesProvider capabilitiesProvider;
    private final ImageCache imageCache;
    private final LayerManager layerManager;
    private final ImageWriter imageWriter;

    public WmsServletRequestProcessor(WmsGetCapabilitiesProvider capabilitiesProvider, Layers layers, ImageCache imageCache, ImageWriter imageWriter) {
        this.capabilitiesProvider = capabilitiesProvider;
        this.imageCache = imageCache;
        this.imageWriter = imageWriter;
        this.layerManager = new LayerManager(layers);
    }

    public static Builder builder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        long t = System.currentTimeMillis();
        try {
            log.info("httpGetUrl=" + request.getRequestURL() + "?" + request.getQueryString());
            log.info("requestedByIP = ip " + request.getRemoteAddr());
            String req = request.getParameter(PARAMETER_REQUEST);
            this.setNoCacheParameters(response);
            if (REQUEST_GET_CAPABILITIES.equals(req)) {
                this.writeCapabilities(request, response);
            } else if (REQUEST_GET_MAP.equals(req)) {
                this.writeImage(request, response);
            } else if (REQUEST_GET_FEATURE_INFO.equals(req)) {
                this.writeFeatureInfo(request, response);
            } else {
                throw new UnknownParameterException("Unrecognized REQUEST parameter: " + req);
            }
            response.getOutputStream().flush();
        }
        catch (UnknownParameterException e) {
            log.warn(e.getMessage());
            throw new ServletException((Throwable)e);
        }
        catch (MissingMandatoryParameterException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            log.info("requestTimeSeconds=" + new DecimalFormat("0.000").format((double)(System.currentTimeMillis() - t) / 1000.0) + "s");
        }
    }

    private void handleException(Exception e) throws ServletException {
        if (e.getClass().getName().contains("ClientAbortException") || e.getMessage() != null && e.getMessage().contains("Broken pipe") || e.getCause() instanceof SocketException) {
            String s = e.getMessage();
            if (s == null) {
                s = e.getClass().getName();
            }
        } else {
            log.error(e.getClass().getName());
            log.error(e.getMessage(), (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        log.warn(e.getMessage());
    }

    private void writeCapabilities(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/xml");
        String capabilities = this.capabilitiesProvider.getCapabilities(request);
        response.getOutputStream().write(capabilities.getBytes());
    }

    private void writeImage(HttpServletRequest request, HttpServletResponse response) throws MissingMandatoryParameterException, IOException {
        log.info("getting image");
        WmsRequest wmsRequest = new WmsRequest(request);
        byte[] bytes = null;
        response.setContentType(wmsRequest.getFormat());
        bytes = this.imageCache.get(wmsRequest);
        if ("false".equals(request.getParameter("cacheImage"))) {
            bytes = null;
        }
        if (bytes == null) {
            log.info("image cache empty");
            BufferedImage image = null;
            image = this.layerManager.getImage(wmsRequest);
            log.info("writing image to memory");
            ByteArrayOutputStream byteOs = new ByteArrayOutputStream();
            String imageType = wmsRequest.getFormat().substring(wmsRequest.getFormat().indexOf(47) + 1);
            long t = System.currentTimeMillis();
            this.imageWriter.writeImage(image, byteOs, imageType);
            log.info("ImageIoWriteTimeMs=  " + (System.currentTimeMillis() - t));
            bytes = byteOs.toByteArray();
            this.imageCache.put(wmsRequest, bytes);
        } else {
            log.info("obtained image from cache");
        }
        log.info("writing image to http output stream");
        response.getOutputStream().write(bytes);
        response.getOutputStream().flush();
        log.info("imageSizeK=" + new DecimalFormat("0.000").format((double)bytes.length / 1000.0));
    }

    private void writeFeatureInfo(HttpServletRequest request, HttpServletResponse response) throws MissingMandatoryParameterException, IOException {
        log.info("getting feature info");
        int i = this.getI(request);
        int j = this.getJ(request);
        WmsRequest wmsRequest = new WmsRequest(request);
        response.setContentType(wmsRequest.getInfoFormat());
        BufferedOutputStream bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
        Map<String, String> infos = this.layerManager.getInfos(new Date(), wmsRequest, new Point(i, j), wmsRequest.getInfoFormat());
        for (Map.Entry<String, String> entry : infos.entrySet()) {
            log.debug(entry.getKey() + "=" + entry.getValue());
            bos.write(("<p>" + entry.getKey() + "</p>").getBytes());
            bos.write(entry.getValue().getBytes());
        }
        bos.close();
    }

    private int getJ(HttpServletRequest request) {
        if (request.getParameter("J") != null) {
            return Math.round(Float.parseFloat(request.getParameter("J")));
        }
        return Math.round(Float.parseFloat(request.getParameter("Y")));
    }

    private int getI(HttpServletRequest request) {
        if (request.getParameter("J") != null) {
            return Math.round(Float.parseFloat(request.getParameter("I")));
        }
        return Math.round(Float.parseFloat(request.getParameter("X")));
    }

    private void setNoCacheParameters(HttpServletResponse response) {
        response.setHeader("Expires", "-1");
        response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        response.addHeader("Cache-Control", "post-check=0, pre-check=0");
        response.setHeader("Pragma", "no-cache");
    }

    public static class Builder {
        private WmsGetCapabilitiesProvider capabilitiesProvider;
        private ImageCache imageCache = new ImageCache();
        private Layers layers;
        private final LayersBuilder layersBuilder = LayersBuilder.builder();
        private final List<String> layersToCache = new ArrayList<String>();
        private ImageWriter imageWriter = new ImageWriterDefault();
        private Integer imageCacheSize;

        private Builder() {
        }

        public Builder capabilities(WmsGetCapabilitiesProvider capabilitiesProvider) {
            this.capabilitiesProvider = capabilitiesProvider;
            return this;
        }

        public Builder capabilitiesFromClasspath(String resource) {
            this.capabilitiesProvider = WmsGetCapabilitiesProviderFromClasspath.fromClasspath(resource);
            return this;
        }

        public Builder imageCache(int size) {
            this.imageCacheSize = size;
            return this;
        }

        public Builder addCachedLayer(String name, Layer layer) {
            return this.addLayer(name, layer, true);
        }

        public Builder addLayer(String name, Layer layer) {
            return this.addLayer(name, layer, false);
        }

        public Builder addLayer(String name, Layer layer, boolean cache) {
            this.layersBuilder.add(name, layer);
            if (cache) {
                this.layersToCache.add(name);
            }
            return this;
        }

        public Builder layers(Layers layers) {
            this.layers = layers;
            return this;
        }

        public Builder imageWriter(ImageWriter imageWriter) {
            this.imageWriter = imageWriter;
            return this;
        }

        public WmsServletRequestProcessor build() {
            if (this.imageCacheSize != null) {
                this.imageCache = new ImageCache(this.imageCacheSize);
            }
            for (String layer : this.layersToCache) {
                this.imageCache.add(layer);
            }
            if (this.layers == null) {
                this.layers = this.layersBuilder.build();
            }
            return new WmsServletRequestProcessor(this.capabilitiesProvider, this.layers, this.imageCache, this.imageWriter);
        }
    }
}

