/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.grumpy.wms;

import com.github.davidmoten.grumpy.core.Position;
import com.github.davidmoten.grumpy.projection.Projector;
import com.github.davidmoten.grumpy.projection.ProjectorBounds;
import com.github.davidmoten.grumpy.util.NearBSpline;
import com.github.davidmoten.grumpy.wms.WmsRequest;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class RendererUtil {
    private static final double DEFAULT_MAX_DISTANCE_BETWEEN_POINTS_IN_PIXELS = 20.0;
    private static final double MAX_DISTANCE_BETWEEN_POINTS_IN_DEGREES = 300.0;

    public static void useAntialiasing(Graphics2D g) {
        RenderingHints renderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        renderHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        renderHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.addRenderingHints(renderHints);
    }

    public static List<Position> joinPixels(Projector projector, Position a, Position b, double maxDistanceBetweenPointsInPixels) {
        if (maxDistanceBetweenPointsInPixels < 2.0) {
            throw new RuntimeException("distance between points in pixels must be greater than 1");
        }
        ArrayList<Position> list = new ArrayList<Position>();
        Point pointA = projector.toPoint(a.getLat(), a.getLon());
        Point pointB = projector.toPoint(b.getLat(), b.getLon());
        double maxDistanceBetweenPointsInKm = 20.0;
        if (a.getDistanceToKm(b) > maxDistanceBetweenPointsInKm && pointA.distance(pointB) >= maxDistanceBetweenPointsInPixels) {
            Position intermediate = a.getPositionAlongPath(b, 0.5);
            List<Position> segment1 = RendererUtil.joinPixels(projector, a, intermediate, maxDistanceBetweenPointsInPixels);
            List<Position> segment2 = RendererUtil.joinPixels(projector, intermediate, b, maxDistanceBetweenPointsInPixels);
            list.addAll(segment1);
            segment2.remove(0);
            list.addAll(segment2);
        } else {
            list.add(a);
            list.add(b);
        }
        return list;
    }

    public static List<Position> joinPixels(Projector projector, double maxDistanceBetweenPointsInPixels, List<Position> mainPositions) {
        ArrayList<Position> positions = new ArrayList<Position>();
        Position lastPosition = null;
        for (Position position : mainPositions) {
            if (lastPosition != null) {
                List<Position> list = RendererUtil.joinPixels(projector, lastPosition, position, maxDistanceBetweenPointsInPixels);
                if (positions.size() > 0) {
                    list.remove(0);
                }
                positions.addAll(list);
            }
            lastPosition = position;
        }
        return positions;
    }

    public static Shape getPath(Projector projector, List<Position> positions) {
        return RendererUtil.getPath(projector, 20.0, positions);
    }

    public static Shape getPath(Projector projector, double maxDistanceBetweenPointsInPixels, List<Position> mainPositions) {
        if (mainPositions.size() < 2) {
            throw new RuntimeException("must provide at least two positions");
        }
        GeneralPath path = new GeneralPath();
        Position lastPosition = null;
        for (Position position : mainPositions) {
            if (position.getLon() > 180.0) {
                position = new Position(position.getLat(), position.getLon() - 360.0);
            } else if (position.getLon() < -180.0) {
                position = new Position(position.getLat(), position.getLon() + 360.0);
            }
            if (lastPosition != null) {
                double currentLon = position.getLon();
                double currentLat = position.getLat();
                double lastLon = lastPosition.getLon();
                if (!RendererUtil.differenceIsLarge(lastLon, currentLon, 300.0)) {
                    List<Position> positions = RendererUtil.joinPixels(projector, maxDistanceBetweenPointsInPixels, Arrays.asList(lastPosition, position));
                    GeneralPath line = new NearBSpline(RendererUtil.getPoints(projector, positions)).getPath();
                    path.append(line.getPathIterator(AffineTransform.getTranslateInstance(0.0, 0.0)), true);
                } else {
                    Point p = projector.toPoint(currentLat, currentLon);
                    path.moveTo(p.x, p.y);
                }
            }
            lastPosition = position;
        }
        return path;
    }

    protected static boolean differenceIsLarge(double lastLon, double lon, double largeDifference) {
        return Math.abs(lastLon - lon) > largeDifference;
    }

    public static Point2D[] getPoints(Projector projector, List<Position> positions) {
        ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
        for (Position position : positions) {
            points.add(projector.toPoint2D(position.getLat(), position.getLon()));
        }
        return points.toArray(new Point2D[0]);
    }

    public static List<Position> getCircle(Position position, double radiusKm, double numPoints) {
        ArrayList<Position> positions = new ArrayList<Position>();
        int i = 0;
        while ((double)i < numPoints) {
            double bearing = 360.0 * (double)i / numPoints;
            Position p = position.predict(radiusKm, bearing).normalizeLongitude();
            p = p.ensureContinuous(position.normalizeLongitude());
            positions.add(p);
            ++i;
        }
        positions.add((Position)positions.get(0));
        return positions;
    }

    public static WmsRequest getAustralianEpsg4326WmsRequest(int width, int height) {
        List<String> e = Collections.emptyList();
        WmsRequest r = new WmsRequest(e, e, e, new ProjectorBounds("EPSG:4326", 90.0, -61.0, 176.0, 61.0), "image/png", width, height, true, Color.white, "1.1.1", null, new HashMap<String, String>(), null, null);
        return r;
    }
}

