/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.grumpy.wms.layer.darkness;

import com.github.davidmoten.grumpy.core.Position;
import com.github.davidmoten.grumpy.projection.Projector;
import com.github.davidmoten.grumpy.wms.Layer;
import com.github.davidmoten.grumpy.wms.LayerFeatures;
import com.github.davidmoten.grumpy.wms.RendererUtil;
import com.github.davidmoten.grumpy.wms.WmsRequest;
import com.github.davidmoten.grumpy.wms.WmsUtil;
import com.github.davidmoten.grumpy.wms.layer.darkness.SunUtil;
import com.github.davidmoten.grumpy.wms.reduction.RectangleSampler;
import com.github.davidmoten.grumpy.wms.reduction.RectangleSamplerCorners;
import com.github.davidmoten.grumpy.wms.reduction.Reducer;
import com.github.davidmoten.grumpy.wms.reduction.ValueRenderer;
import com.google.common.base.Function;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;

public class DarknessLayer
implements Layer {
    private static final String STYLE_PLAIN = "plain";
    private static final int SUB_SOLAR_POINT_SIZE_PIXELS = 30;
    private static final Map<SunUtil.Twilight, Color> shades = DarknessLayer.createShades();
    private final BufferedImage subSolarImage = DarknessLayer.loadSubSolarPointImage();
    private final LayerFeatures features = LayerFeatures.builder().name("Darkness").style("plain").crs("EPSG:4326").crs("EPSG:3857").build();

    public void render(Graphics2D g, WmsRequest request) {
        Projector projector = WmsUtil.getProjector((WmsRequest)request);
        Position subSolarPoint = SunUtil.getSubSolarPoint();
        DarknessLayer.renderSubSolarPoint(g, subSolarPoint, projector, this.subSolarImage, request.getStyles());
        DarknessLayer.renderTwilight(g, subSolarPoint, projector);
    }

    private static void renderSubSolarPoint(Graphics2D g, Position subSolarPoint, Projector projector, BufferedImage subSolarImage, List<String> styles) {
        Point point = projector.toPoint(subSolarPoint.getLat(), subSolarPoint.getLon());
        int size = 30;
        if (styles.contains(STYLE_PLAIN)) {
            DarknessLayer.fillCircle(g, point, size);
        } else {
            g.drawImage(subSolarImage, point.x - size / 2, point.y - size / 2, size, size, null);
        }
    }

    private static void fillCircle(Graphics2D g, Point point, int size) {
        Ellipse2D.Double spot = new Ellipse2D.Double();
        g.setColor(Color.YELLOW);
        ((RectangularShape)spot).setFrame(point.x - size / 2, point.y - size / 2, size, size);
        g.fill(spot);
    }

    private static BufferedImage loadSubSolarPointImage() {
        try {
            return ImageIO.read(DarknessLayer.class.getResourceAsStream("/sunny.png"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void renderTwilight(Graphics2D g, Position subSolarPoint, Projector projector) {
        Function<Position, SunUtil.Twilight> function = DarknessLayer.createValueFunction(subSolarPoint);
        ValueRenderer<SunUtil.Twilight> valueRenderer = DarknessLayer.createValueRenderer();
        RectangleSamplerCorners sampler = new RectangleSamplerCorners();
        Reducer.render((Graphics2D)g, function, (Projector)projector, (RectangleSampler)sampler, valueRenderer);
    }

    private static Function<Position, SunUtil.Twilight> createValueFunction(final Position subSolarPoint) {
        return new Function<Position, SunUtil.Twilight>(){

            public SunUtil.Twilight apply(Position p) {
                return SunUtil.getTwilight(subSolarPoint, p);
            }
        };
    }

    private static ValueRenderer<SunUtil.Twilight> createValueRenderer() {
        return new ValueRenderer<SunUtil.Twilight>(){

            public void render(Graphics2D g, Projector projector, Rectangle region, SunUtil.Twilight t) {
                DarknessLayer.renderBounds(g, projector, region, t);
            }
        };
    }

    private static void renderBounds(Graphics2D g, Projector projector, Rectangle region, SunUtil.Twilight twilight) {
        if (twilight != SunUtil.Twilight.DAYLIGHT) {
            List box = WmsUtil.getBorder((Projector)projector, (Rectangle)region);
            List path = RendererUtil.toPath((Projector)projector, (List)box);
            g.setColor(shades.get((Object)twilight));
            RendererUtil.fill((Graphics2D)g, (List)path);
        }
    }

    private static Map<SunUtil.Twilight, Color> createShades() {
        HashMap<SunUtil.Twilight, Color> shades = new HashMap<SunUtil.Twilight, Color>();
        shades.put(SunUtil.Twilight.NIGHT, Color.BLACK);
        shades.put(SunUtil.Twilight.ASTRONOMICAL, new Color(50, 50, 50));
        shades.put(SunUtil.Twilight.NAUTICAL, new Color(100, 100, 100));
        shades.put(SunUtil.Twilight.CIVIL, new Color(150, 150, 150));
        shades.put(SunUtil.Twilight.DAYLIGHT, Color.WHITE);
        return shades;
    }

    public String getInfo(Date time, WmsRequest request, Point point, String format) {
        return null;
    }

    public LayerFeatures getFeatures() {
        return this.features;
    }
}

