/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.geo;

import java.util.Arrays;

class CoverageLongs {
    private final long[] hashes;
    private final int count;
    private final double ratio;

    public CoverageLongs(long[] hashes, int count, double ratio) {
        this.hashes = hashes;
        this.count = count;
        this.ratio = ratio;
    }

    public long[] getHashes() {
        return Arrays.copyOf(this.hashes, this.count);
    }

    public double getRatio() {
        return this.ratio;
    }

    public int getHashLength() {
        if (this.count == 0) {
            return 0;
        }
        return (int)(this.hashes[0] & 0xFL);
    }

    public String toString() {
        return "Coverage [hashes=" + this.getHashes() + ", ratio=" + this.ratio + "]";
    }

    public int getCount() {
        return this.count;
    }
}

