/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.geo;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.awt.Polygon;
import java.text.DecimalFormat;
import java.util.List;

public class Position {
    private final double lat;
    private final double lon;
    private final double altitudeMetres;
    private static final double radiusEarthKm = 6371.01;

    public Position(double lat, double lon) {
        this(lat, lon, 0.0);
    }

    public Position(double lat, double lon, double altitudeMetres) {
        this.lat = lat;
        this.lon = lon;
        this.altitudeMetres = altitudeMetres;
    }

    public final double getLat() {
        return this.lat;
    }

    public final double getLon() {
        return this.lon;
    }

    public final double getAlt() {
        return this.altitudeMetres;
    }

    public final String toString() {
        return "[" + this.lat + "," + this.lon + "]";
    }

    public final Position predict(double distanceKm, double courseDegrees) {
        Preconditions.checkArgument((Math.abs(this.altitudeMetres) < 1.0E-6 ? 1 : 0) != 0, (Object)"Predictions only valid for Earth's surface (position altitude must be zero)");
        double dr = distanceKm / 6371.01;
        double latR = Math.toRadians(this.lat);
        double lonR = Math.toRadians(this.lon);
        double courseR = Math.toRadians(courseDegrees);
        double lat2Radians = Math.asin(Math.sin(latR) * Math.cos(dr) + Math.cos(latR) * Math.sin(dr) * Math.cos(courseR));
        double lon2Radians = Math.atan2(Math.sin(courseR) * Math.sin(dr) * Math.cos(latR), Math.cos(dr) - Math.sin(latR) * Math.sin(lat2Radians));
        double lon3Radians = Position.mod(lonR + lon2Radians + Math.PI, Math.PI * 2) - Math.PI;
        return new Position(Math.toDegrees(lat2Radians), Math.toDegrees(lon3Radians));
    }

    public static double toDegrees(double degrees, double minutes, double seconds) {
        return degrees + minutes / 60.0 + seconds / 3600.0;
    }

    private double sqr(double d) {
        return d * d;
    }

    public final double getDistanceToKm(Position position) {
        double lat1 = Math.toRadians(this.lat);
        double lat2 = Math.toRadians(position.lat);
        double lon1 = Math.toRadians(this.lon);
        double lon2 = Math.toRadians(position.lon);
        double deltaLon = lon2 - lon1;
        double top = Math.sqrt(this.sqr(Math.cos(lat2) * Math.sin(deltaLon)) + this.sqr(Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * Math.cos(lat2) * Math.cos(deltaLon)));
        double bottom = Math.sin(lat1) * Math.sin(lat2) + Math.cos(lat1) * Math.cos(lat2) * Math.cos(deltaLon);
        double distance = 6371.01 * Math.atan2(top, bottom);
        return Math.abs(distance);
    }

    public final double getBearingDegrees(Position position) {
        double x;
        double lat1 = Math.toRadians(this.lat);
        double lat2 = Math.toRadians(position.lat);
        double lon1 = Math.toRadians(this.lon);
        double lon2 = Math.toRadians(position.lon);
        double dLon = lon2 - lon1;
        double y = Math.sin(dLon) * Math.cos(lat2);
        double course = Math.toDegrees(Math.atan2(y, x = Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * Math.cos(lat2) * Math.cos(dLon)));
        if (course < 0.0) {
            course += 360.0;
        }
        return course;
    }

    public static double getBearingDifferenceDegrees(double bearing1, double bearing2) {
        double result;
        if (bearing1 < 0.0) {
            bearing1 += 360.0;
        }
        if (bearing2 > 180.0) {
            bearing2 -= 360.0;
        }
        if ((result = bearing1 - bearing2) > 180.0) {
            result -= 360.0;
        }
        return result;
    }

    public static String toDegreesMinutesDecimalMinutesLatitude(double lat) {
        long degrees = Math.round(Math.signum(lat) * Math.floor(Math.abs(lat)));
        double remaining = Math.abs(lat - (double)degrees);
        String result = Math.abs(degrees) + "" + '\u00b0' + new DecimalFormat("00.00").format(remaining *= 60.0) + "'" + (lat < 0.0 ? "S" : "N");
        return result;
    }

    public static String toDegreesMinutesDecimalMinutesLongitude(double lon) {
        long degrees = Math.round(Math.signum(lon) * Math.floor(Math.abs(lon)));
        double remaining = Math.abs(lon - (double)degrees);
        String result = Math.abs(degrees) + "" + '\u00b0' + new DecimalFormat("00.00").format(remaining *= 60.0) + "'" + (lon < 0.0 ? "W" : "E");
        return result;
    }

    @VisibleForTesting
    static double mod(double y, double x) {
        int n;
        double mod = y - (x = Math.abs(x)) * (double)(n = (int)(y / x));
        if (mod < 0.0) {
            mod += x;
        }
        return mod;
    }

    public final Position getPositionAlongPath(Position position, double proportion) {
        if (proportion >= 0.0 && proportion <= 1.0) {
            double courseDegrees = this.getBearingDegrees(position);
            double distanceKm = this.getDistanceToKm(position);
            Position retPosition = this.predict(proportion * distanceKm, courseDegrees);
            return retPosition;
        }
        throw new RuntimeException("Proportion must be between 0 and 1 inclusive");
    }

    public final Position ensureContinuous(Position lastPosition) {
        double lon = this.lon;
        if (Math.abs(lon - lastPosition.lon) > 180.0) {
            lon = lastPosition.lon < 0.0 ? (lon -= 360.0) : (lon += 360.0);
            return new Position(this.lat, lon);
        }
        return this;
    }

    public final boolean isWithin(List<Position> positions) {
        Polygon polygon = new Polygon();
        for (Position p : positions) {
            polygon.addPoint(this.degreesToArbitraryInteger(p.lon), this.degreesToArbitraryInteger(p.lat));
        }
        int x = this.degreesToArbitraryInteger(this.lon);
        int y = this.degreesToArbitraryInteger(this.lat);
        return polygon.contains(x, y);
    }

    private int degreesToArbitraryInteger(double d) {
        return (int)Math.round(d * 3600.0);
    }

    public final boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Position) {
            Position p = (Position)o;
            return p.lat == this.lat && p.lon == this.lon;
        }
        return false;
    }

    public final int hashCode() {
        return (int)(this.lat + this.lon);
    }

    public final double getDistanceToPathKm(List<Position> positions) {
        if (positions.size() == 0) {
            throw new RuntimeException("positions must not be empty");
        }
        if (positions.size() == 1) {
            return this.getDistanceToKm(positions.get(0));
        }
        Double distance = null;
        for (int i = 0; i < positions.size() - 1; ++i) {
            double d = this.getDistanceToSegmentKm(positions.get(i), positions.get(i + 1));
            if (distance != null && !(d < distance)) continue;
            distance = d;
        }
        return distance;
    }

    public final double getDistanceToSegmentKm(Position p1, Position p2) {
        return this.getDistanceToKm(this.getClosestIntersectionWithSegment(p1, p2));
    }

    public final Position getClosestIntersectionWithSegment(Position p1, Position p2) {
        double bearing2;
        double bearing1;
        double bearingDiff;
        if (p1.equals(p2)) {
            return p1;
        }
        double d = this.getDistanceToKm(p1);
        double proportion = d * Math.cos(Math.toRadians(bearingDiff = (bearing1 = p1.getBearingDegrees(this)) - (bearing2 = p1.getBearingDegrees(p2)))) / p1.getDistanceToKm(p2);
        if (proportion < 0.0 || proportion > 1.0) {
            if (d < this.getDistanceToKm(p2)) {
                return p1;
            }
            return p2;
        }
        return p1.getPositionAlongPath(p2, proportion);
    }

    public boolean isOutside(List<Position> path, double minDistanceKm) {
        if (this.isWithin(path)) {
            return false;
        }
        double distance = this.getDistanceToPathKm(path);
        return distance >= minDistanceKm;
    }

    public static Position create(double lat, double lon) {
        return new Position(lat, lon);
    }

    public static double longitudeDiff(double a, double b) {
        if ((a = Position.to180(a)) < (b = Position.to180(b))) {
            return a - b + 360.0;
        }
        return a - b;
    }

    public static double to180(double d) {
        if (d < 0.0) {
            return -Position.to180(Math.abs(d));
        }
        if (d > 180.0) {
            long n = Math.round(Math.floor((d + 180.0) / 360.0));
            return d - (double)(n * 360L);
        }
        return d;
    }
}

