/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidfantasy.mybatisplus.generatorui.sqlparser;

import com.github.davidfantasy.mybatisplus.generatorui.sqlparser.ConditionExpr;
import com.google.common.collect.Lists;
import java.util.List;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.Between;
import net.sf.jsqlparser.expression.operators.relational.ComparisonOperator;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SubSelect;

public class WhereParser
extends ExpressionVisitorAdapter {
    private String currentLogicOp;
    private List<ConditionExpr> conditions = Lists.newArrayList();

    public List<ConditionExpr> getConditions() {
        return this.conditions;
    }

    public void visit(AndExpression expr) {
        this.parseLogicOperator((BinaryExpression)expr, "AND");
    }

    public void visit(OrExpression expr) {
        this.parseLogicOperator((BinaryExpression)expr, "OR");
    }

    public void visit(Between expr) {
        this.parseBetweenOperator(expr);
    }

    public void visit(GreaterThan expr) {
        this.parseComparisonOperator((ComparisonOperator)expr);
    }

    public void visit(GreaterThanEquals expr) {
        this.parseComparisonOperator((ComparisonOperator)expr);
    }

    public void visit(MinorThan expr) {
        this.parseComparisonOperator((ComparisonOperator)expr);
    }

    public void visit(MinorThanEquals expr) {
        this.parseComparisonOperator((ComparisonOperator)expr);
    }

    public void visit(LikeExpression expr) {
        this.parseCommonOperator(expr.getLeftExpression(), expr.getRightExpression(), "like");
    }

    public void visit(NotEqualsTo expr) {
        this.parseComparisonOperator((ComparisonOperator)expr);
    }

    public void visit(EqualsTo expr) {
        this.parseComparisonOperator((ComparisonOperator)expr);
    }

    public void visit(InExpression expr) {
        if (expr.getRightExpression() != null) {
            this.parseCommonOperator(expr.getLeftExpression(), expr.getRightExpression(), "in");
        } else {
            this.currentLogicOp = "";
            expr.getRightItemsList().accept((ItemsListVisitor)this);
        }
    }

    public void visit(SubSelect subSelect) {
        PlainSelect ps = (PlainSelect)subSelect.getSelectBody();
        ps.getWhere().accept((ExpressionVisitor)this);
    }

    private void parseLogicOperator(BinaryExpression binaryExpression, String operator) {
        binaryExpression.getLeftExpression().accept((ExpressionVisitor)this);
        this.currentLogicOp = operator;
        binaryExpression.getRightExpression().accept((ExpressionVisitor)this);
    }

    private void parseComparisonOperator(ComparisonOperator operator) {
        this.parseCommonOperator(operator.getLeftExpression(), operator.getRightExpression(), operator.getStringExpression());
    }

    private void parseBetweenOperator(Between between) {
        if (ConditionExpr.isDynamicParam(between.getBetweenExpressionStart().toString()) || ConditionExpr.isDynamicParam(between.getBetweenExpressionEnd().toString())) {
            ConditionExpr condition = new ConditionExpr();
            condition.setLogicOperator(this.currentLogicOp);
            condition.setLeftExpr(between.getLeftExpression().toString());
            condition.setOperator("between");
            condition.setRightExpr(between.getBetweenExpressionStart().toString());
            condition.setMiddleOperator("and");
            condition.setEndExpr(between.getBetweenExpressionEnd().toString());
            condition.parseDynamicParams(between.getBetweenExpressionStart().toString());
            condition.parseDynamicParams(between.getBetweenExpressionEnd().toString());
            this.conditions.add(condition);
        }
        this.currentLogicOp = "";
    }

    private void parseCommonOperator(Expression left, Expression right, String operator) {
        if (left == null || right == null) {
            this.currentLogicOp = "";
            return;
        }
        if (ConditionExpr.isDynamicParam(right.toString())) {
            ConditionExpr condition = new ConditionExpr();
            condition.setLeftExpr(left.toString());
            condition.setOperator(operator);
            condition.setRightExpr(right.toString());
            condition.setLogicOperator(this.currentLogicOp);
            condition.parseDynamicParams(right.toString());
            this.conditions.add(condition);
        }
        this.currentLogicOp = "";
    }
}

