/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidfantasy.mybatisplus.generatorui.service;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import com.github.davidfantasy.mybatisplus.generatorui.ProjectPathResolver;
import com.github.davidfantasy.mybatisplus.generatorui.dto.DtoFieldInfo;
import com.github.davidfantasy.mybatisplus.generatorui.dto.JavaClassMethodInfo;
import com.github.davidfantasy.mybatisplus.generatorui.util.PathUtil;
import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.Parameter;
import java.io.FileInputStream;
import java.io.InputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JavaClassParser {
    private JavaParser jp = new JavaParser();
    @Autowired
    private ProjectPathResolver pathResolver;

    public void addMethod2Interface(JavaClassMethodInfo methodInfo) throws Exception {
        String sourcePath = this.pathResolver.convertPackageToPath(methodInfo.getClassRef()) + ".java";
        FileInputStream in = new FileInputStream(sourcePath);
        ParseResult result = this.jp.parse((InputStream)in);
        CompilationUnit cu = (CompilationUnit)result.getResult().get();
        for (String importJavaType : methodInfo.getImportJavaTypes()) {
            cu.addImport(importJavaType);
        }
        String className = PathUtil.getShortNameFromFullRef(methodInfo.getClassRef());
        ClassOrInterfaceDeclaration clazz = (ClassOrInterfaceDeclaration)cu.getInterfaceByName(className).get();
        NodeList params = new NodeList();
        for (DtoFieldInfo field : methodInfo.getParams()) {
            Parameter param = new Parameter();
            param.setName(field.getPropertyName());
            param.setType(field.getShortJavaType());
            if (field.getAnnotations() != null) {
                param.setAnnotations(field.getAnnotations());
            }
            params.add((Node)param);
        }
        clazz.addMethod(methodInfo.getMethodName(), new Modifier.Keyword[0]).setParameters(params).setBody(null).setType(PathUtil.getShortNameFromFullRef(methodInfo.getReturnType()));
        FileUtil.writeFromStream((InputStream)IoUtil.toStream((String)cu.toString(), (String)"utf-8"), (String)sourcePath);
    }
}

