/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.datatables;

import java.util.ArrayList;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.datatables.ColumnFilter;
import org.springframework.data.jpa.datatables.Filter;
import org.springframework.data.jpa.datatables.GlobalFilter;
import org.springframework.data.jpa.datatables.Node;
import org.springframework.data.jpa.datatables.mapping.Column;
import org.springframework.data.jpa.datatables.mapping.DataTablesInput;
import org.springframework.data.jpa.datatables.mapping.Order;
import org.springframework.data.jpa.datatables.mapping.Search;
import org.springframework.util.StringUtils;

abstract class AbstractPredicateBuilder<T> {
    protected final DataTablesInput input;
    final boolean hasGlobalFilter;
    final Node<Filter> tree;

    AbstractPredicateBuilder(DataTablesInput input) {
        this.input = input;
        this.hasGlobalFilter = input.getSearch() != null && StringUtils.hasText((String)input.getSearch().getValue());
        this.tree = this.hasGlobalFilter ? new Node<GlobalFilter>(null, new GlobalFilter(input.getSearch().getValue())) : new Node(null);
        this.initTree(input);
    }

    private void initTree(DataTablesInput input) {
        for (Column column : input.getColumns()) {
            if (!column.getSearchable().booleanValue()) continue;
            this.addChild(this.tree, 0, column.getData().split("\\."), column.getSearch());
        }
    }

    private void addChild(Node<Filter> parent, int index, String[] names, Search search) {
        boolean isLast;
        boolean bl = isLast = index + 1 == names.length;
        if (isLast) {
            boolean hasColumnFilter = search != null && StringUtils.hasText((String)search.getValue());
            parent.addChild(new Node<ColumnFilter>(names[index], hasColumnFilter ? new ColumnFilter(search.getValue()) : null));
        } else {
            Node<Filter> child = parent.getOrCreateChild(names[index]);
            this.addChild(child, index + 1, names, search);
        }
    }

    public Pageable createPageable() {
        Sort sort;
        ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
        for (Order order : this.input.getOrder()) {
            Column column = this.input.getColumns().get(order.getColumn());
            if (!column.getOrderable().booleanValue()) continue;
            String sortColumn = column.getData();
            Sort.Direction sortDirection = Sort.Direction.fromString((String)order.getDir());
            orders.add(new Sort.Order(sortDirection, sortColumn));
        }
        Sort sort2 = sort = orders.isEmpty() ? null : new Sort(orders);
        if (this.input.getLength() == -1) {
            this.input.setStart(0);
            this.input.setLength(Integer.MAX_VALUE);
        }
        return new DataTablesPageRequest(this.input.getStart(), this.input.getLength(), sort);
    }

    public abstract T build();

    private class DataTablesPageRequest
    implements Pageable {
        private final int offset;
        private final int pageSize;
        private final Sort sort;

        DataTablesPageRequest(int offset, int pageSize, Sort sort) {
            this.offset = offset;
            this.pageSize = pageSize;
            this.sort = sort;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getPageSize() {
            return this.pageSize;
        }

        public Sort getSort() {
            return this.sort;
        }

        public Pageable next() {
            throw new UnsupportedOperationException();
        }

        public Pageable previousOrFirst() {
            throw new UnsupportedOperationException();
        }

        public Pageable first() {
            throw new UnsupportedOperationException();
        }

        public boolean hasPrevious() {
            throw new UnsupportedOperationException();
        }

        public int getPageNumber() {
            throw new UnsupportedOperationException();
        }
    }
}

