/*
 * Decompiled with CFR 0.152.
 */
package com.github.dapeng.maven.plugin;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class SoaAbstractMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;

    protected ClassLoader getClassLoader() throws MojoExecutionException {
        URLClassLoader urlClassLoader = (URLClassLoader)Thread.currentThread().getContextClassLoader();
        URL[] urLs = urlClassLoader.getURLs();
        ArrayList<URL> classpathURLs = new ArrayList<URL>(Arrays.asList(urLs));
        this.addRelevantProjectDependenciesToClasspath(classpathURLs);
        return new URLClassLoader(classpathURLs.toArray(new URL[classpathURLs.size()]));
    }

    protected void addRelevantProjectDependenciesToClasspath(List<URL> path) throws MojoExecutionException {
        try {
            this.getLog().debug((CharSequence)"Project Dependencies will be included.");
            ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
            ArrayList<File> theClasspathFiles = new ArrayList<File>();
            this.collectProjectArtifactsAndClasspath(artifacts, theClasspathFiles);
            for (File classpathFile : theClasspathFiles) {
                URL url = classpathFile.toURI().toURL();
                this.getLog().debug((CharSequence)("Adding to classpath : " + url));
                path.add(url);
            }
            for (Artifact classPathElement : artifacts) {
                this.getLog().debug((CharSequence)("Adding project dependency artifact: " + classPathElement.getArtifactId() + " to classpath"));
                path.add(classPathElement.getFile().toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Error during setting up classpath", (Exception)e);
        }
    }

    protected void collectProjectArtifactsAndClasspath(List<Artifact> artifacts, List<File> theClasspathFiles) {
        artifacts.addAll(this.project.getRuntimeArtifacts());
        artifacts.addAll(this.project.getSystemArtifacts());
        theClasspathFiles.add(new File(this.project.getBuild().getOutputDirectory()));
    }

    protected void joinNonDaemonThreads(ThreadGroup threadGroup) {
        boolean foundNonDaemon;
        do {
            foundNonDaemon = false;
            Collection<Thread> threads = this.getActiveThreads(threadGroup);
            for (Thread thread : threads) {
                if (thread.isDaemon()) continue;
                foundNonDaemon = true;
                this.joinThread(thread, 0L);
            }
        } while (foundNonDaemon);
    }

    protected Collection<Thread> getActiveThreads(ThreadGroup threadGroup) {
        Thread[] threads = new Thread[threadGroup.activeCount()];
        int numThreads = threadGroup.enumerate(threads);
        ArrayList<Thread> result = new ArrayList<Thread>(numThreads);
        for (int i = 0; i < threads.length && threads[i] != null; ++i) {
            result.add(threads[i]);
        }
        return result;
    }

    protected void joinThread(Thread thread, long timeoutMsecs) {
        try {
            this.getLog().debug((CharSequence)("joining on thread " + thread));
            thread.join(timeoutMsecs);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.getLog().warn((CharSequence)("interrupted while joining against thread " + thread), (Throwable)e);
        }
        if (thread.isAlive()) {
            this.getLog().warn((CharSequence)("thread " + thread + " was interrupted but is still alive after waiting at least " + timeoutMsecs + "msecs"));
        }
    }

    class IsolatedThreadGroup
    extends ThreadGroup {
        private Throwable uncaughtException;

        public IsolatedThreadGroup(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                return;
            }
            IsolatedThreadGroup isolatedThreadGroup = this;
            synchronized (isolatedThreadGroup) {
                if (this.uncaughtException == null) {
                    this.uncaughtException = throwable;
                }
            }
            SoaAbstractMojo.this.getLog().warn(throwable);
        }
    }
}

