/*
 * Decompiled with CFR 0.152.
 */
package com.github.dapeng.maven.plugin;

import com.github.dapeng.code.Scrooge;
import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="thriftGenerator")
public class GenerateFilePlugin
extends AbstractMojo {
    @Parameter(property="thriftGenerator.sourceFilePath")
    private String sourceFilePath;
    @Parameter(property="thriftGenerator.targetFilePath")
    private String targetFilePath;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(property="thriftGenerator.language", defaultValue="both")
    private String language;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String separator = System.getProperty("file.separator");
        String projectPath = new File(this.project.getBuild().getOutputDirectory()).getAbsolutePath().replace("target" + System.getProperty("file.separator") + "classes", "");
        this.sourceFilePath = projectPath + (this.sourceFilePath == null ? "src" + separator + "main" + separator + "resources" + separator + "thrift" + separator : this.sourceFilePath);
        this.targetFilePath = projectPath + (this.targetFilePath == null ? "src" + separator + "main" + separator : this.targetFilePath);
        System.out.println(" sourceFilePath: " + this.sourceFilePath);
        System.out.println(" targetFilePath: " + this.targetFilePath);
        if ("both".equals(this.language) || "java".equals(this.language)) {
            Scrooge.main((String[])new String[]{"-gen", "java", "-all", "-in", this.sourceFilePath, "-out", this.targetFilePath});
        }
        if ("both".equals(this.language) || "scala".equals(this.language)) {
            Scrooge.main((String[])new String[]{"-gen", "scala", "-all", "-in", this.sourceFilePath, "-out", this.targetFilePath});
        }
    }

    private static void deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                if ("serializer".equals(children[i])) continue;
                GenerateFilePlugin.deleteDir(new File(dir, children[i]));
            }
        }
        if (!"serializer".equals(dir.getName())) {
            dir.delete();
        }
    }
}

