/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.release;

import com.github.danielflower.mavenplugins.release.AnnotatedTag;
import com.github.danielflower.mavenplugins.release.DiffDetector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class TreeWalkingDiffDetector
implements DiffDetector {
    private final Repository repo;

    public TreeWalkingDiffDetector(Repository repo) {
        this.repo = repo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasChangedSince(String modulePath, List<String> childModules, Collection<AnnotatedTag> tags) throws IOException {
        RevWalk walk = new RevWalk(this.repo);
        try {
            walk.setRetainBody(false);
            walk.markStart(walk.parseCommit((AnyObjectId)this.repo.getRefDatabase().findRef("HEAD").getObjectId()));
            this.filterOutOtherModulesChanges(modulePath, childModules, walk);
            TreeWalkingDiffDetector.stopWalkingWhenTheTagsAreHit(tags, walk);
            boolean bl = walk.iterator().hasNext();
            return bl;
        }
        finally {
            walk.dispose();
        }
    }

    private static void stopWalkingWhenTheTagsAreHit(Collection<AnnotatedTag> tags, RevWalk walk) throws IOException {
        for (AnnotatedTag tag : tags) {
            ObjectId commitId = tag.ref().getTarget().getObjectId();
            RevCommit revCommit = walk.parseCommit((AnyObjectId)commitId);
            walk.markUninteresting(revCommit);
        }
    }

    private void filterOutOtherModulesChanges(String modulePath, List<String> childModules, RevWalk walk) {
        boolean isRootModule = ".".equals(modulePath);
        boolean isMultiModuleProject = !isRootModule || !childModules.isEmpty();
        ArrayList<Object> treeFilters = new ArrayList<Object>();
        treeFilters.add(TreeFilter.ANY_DIFF);
        if (isMultiModuleProject) {
            if (!isRootModule) {
                treeFilters.add(PathFilter.create((String)modulePath));
            }
            for (String childModule : childModules) {
                String path = isRootModule ? childModule : modulePath + "/" + childModule;
                treeFilters.add(PathFilter.create((String)path).negate());
            }
        }
        TreeFilter treeFilter = treeFilters.size() == 1 ? (TreeFilter)treeFilters.get(0) : AndTreeFilter.create(treeFilters);
        walk.setTreeFilter(treeFilter);
    }
}

