/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielfelgar.drawreceiptlib;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import com.github.danielfelgar.drawreceiptlib.DrawBlankSpace;
import com.github.danielfelgar.drawreceiptlib.DrawImage;
import com.github.danielfelgar.drawreceiptlib.DrawLine;
import com.github.danielfelgar.drawreceiptlib.DrawText;
import com.github.danielfelgar.drawreceiptlib.IDrawItem;
import java.util.ArrayList;
import java.util.List;

public class ReceiptBuilder {
    List<IDrawItem> listItens = new ArrayList<IDrawItem>();
    private int backgroundColor = -1;
    private float textSize;
    private int color = -16777216;
    private int width;
    private int marginTop;
    private int marginBottom;
    private int marginLeft;
    private int marginRight;
    private Typeface typeface;
    private Paint.Align align = Paint.Align.LEFT;

    public ReceiptBuilder(int width) {
        this.width = width;
    }

    public ReceiptBuilder setTextSize(float textSize) {
        this.textSize = textSize;
        return this;
    }

    public ReceiptBuilder setBackgroudColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public ReceiptBuilder setColor(int color) {
        this.color = color;
        return this;
    }

    public ReceiptBuilder setTypeface(Context context, String typefacePath) {
        this.typeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)typefacePath);
        return this;
    }

    public ReceiptBuilder setDefaultTypeface() {
        this.typeface = null;
        return this;
    }

    public ReceiptBuilder setAlign(Paint.Align align) {
        this.align = align;
        return this;
    }

    public ReceiptBuilder setMargin(int margin) {
        this.marginLeft = margin;
        this.marginRight = margin;
        this.marginTop = margin;
        this.marginBottom = margin;
        return this;
    }

    public ReceiptBuilder setMargin(int marginTopBottom, int marginLeftRight) {
        this.marginLeft = marginLeftRight;
        this.marginRight = marginLeftRight;
        this.marginTop = marginTopBottom;
        this.marginBottom = marginTopBottom;
        return this;
    }

    public ReceiptBuilder setMarginLeft(int margin) {
        this.marginLeft = margin;
        return this;
    }

    public ReceiptBuilder setMarginRight(int margin) {
        this.marginRight = margin;
        return this;
    }

    public ReceiptBuilder setMarginTop(int margin) {
        this.marginTop = margin;
        return this;
    }

    public ReceiptBuilder setMarginBottom(int margin) {
        this.marginBottom = margin;
        return this;
    }

    public ReceiptBuilder addText(String text) {
        return this.addText(text, true);
    }

    public ReceiptBuilder addText(String text, Boolean newLine) {
        DrawText drawerText = new DrawText(text);
        drawerText.setTextSize(this.textSize);
        drawerText.setColor(this.color);
        drawerText.setNewLine(newLine);
        if (this.typeface != null) {
            drawerText.setTypeface(this.typeface);
        }
        if (this.align != null) {
            drawerText.setAlign(this.align);
        }
        this.listItens.add(drawerText);
        return this;
    }

    public ReceiptBuilder addImage(Bitmap bitmap) {
        DrawImage drawerImage = new DrawImage(bitmap);
        if (this.align != null) {
            drawerImage.setAlign(this.align);
        }
        this.listItens.add(drawerImage);
        return this;
    }

    public ReceiptBuilder addItem(IDrawItem item) {
        this.listItens.add(item);
        return this;
    }

    public ReceiptBuilder addBlankSpace(int heigth) {
        this.listItens.add(new DrawBlankSpace(heigth));
        return this;
    }

    public ReceiptBuilder addParagraph() {
        this.listItens.add(new DrawBlankSpace((int)this.textSize));
        return this;
    }

    public ReceiptBuilder addLine() {
        return this.addLine(this.width - this.marginRight - this.marginLeft);
    }

    public ReceiptBuilder addLine(int size) {
        DrawLine line = new DrawLine(size);
        line.setAlign(this.align);
        line.setColor(this.color);
        this.listItens.add(line);
        return this;
    }

    private int getHeight() {
        int height = 5 + this.marginTop + this.marginBottom;
        for (IDrawItem item : this.listItens) {
            height += item.getHeight();
        }
        return height;
    }

    private Bitmap drawImage() {
        Bitmap image = Bitmap.createBitmap((int)(this.width - this.marginRight - this.marginLeft), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(image);
        canvas.drawColor(this.backgroundColor);
        float size = this.marginTop;
        for (IDrawItem item : this.listItens) {
            item.drawOnCanvas(canvas, 0.0f, size);
            size += (float)item.getHeight();
        }
        return image;
    }

    public Bitmap build() {
        Bitmap image = Bitmap.createBitmap((int)this.width, (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(image);
        Paint paint = new Paint();
        canvas.drawColor(this.backgroundColor);
        canvas.drawBitmap(this.drawImage(), (float)this.marginLeft, 0.0f, paint);
        return image;
    }
}

