/*
 * Decompiled with CFR 0.152.
 */
package com.github.dakusui.jcunit.generators;

import com.github.dakusui.jcunit.core.Checks;
import com.github.dakusui.jcunit.core.Param;
import com.github.dakusui.jcunit.core.ParamType;
import com.github.dakusui.jcunit.core.SystemProperties;
import com.github.dakusui.jcunit.core.Utils;
import com.github.dakusui.jcunit.core.rules.Recorder;
import com.github.dakusui.jcunit.core.tuples.Tuple;
import com.github.dakusui.jcunit.core.tuples.TupleUtils;
import com.github.dakusui.jcunit.generators.IPO2TupleGenerator;
import com.github.dakusui.jcunit.generators.TupleGeneratorBase;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;

public class Replayer
extends TupleGeneratorBase {
    private final GenerationMode generationMode = SystemProperties.isReplayerEnabled() ? GenerationMode.Replay : GenerationMode.Fallback;
    private SortedMap<Long, Tuple> tuples;
    private TupleGeneratorBase fallbackGenerator;

    @Override
    public Tuple getTuple(int tupleId) {
        return this.generationMode.getTuple(this, tupleId);
    }

    @Override
    protected long initializeTuples(Object[] params) {
        return this.generationMode.initializeTuples(this, params);
    }

    private long getIdFromDirName(String dirName) {
        return Long.parseLong(dirName.substring(dirName.lastIndexOf(45) + 1));
    }

    @Override
    public long nextId(long tupleId) {
        return this.generationMode.nextId(this, tupleId);
    }

    @Override
    public long firstId() {
        return this.generationMode.firstId(this);
    }

    private File[] getRecordedTupleDirectories(final ReplayMode mode, File baseDir, final FoundTupleObserver obs) {
        return baseDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String s) {
                String prefix = "data-";
                if (!s.startsWith(prefix)) {
                    return false;
                }
                if (!new File(dir, s).isDirectory()) {
                    return false;
                }
                try {
                    int i = Integer.parseInt(s.substring(prefix.length()));
                    if (i < 0) {
                        return false;
                    }
                }
                catch (NumberFormatException e) {
                    return false;
                }
                File f = new File(dir, s);
                obs.found(f);
                return mode.shouldBeReplayed(f);
            }
        });
    }

    @Override
    public ParamType[] parameterTypes() {
        return new ParamType[]{new ParamType.NonArrayType(){

            @Override
            protected Object parse(String str) {
                return ReplayMode.valueOf(str);
            }

            public String toString() {
                return Replayer.class.getCanonicalName() + ".ReplayMode";
            }
        }.withDefaultValue((Object)ReplayMode.All), ParamType.String.withDefaultValue(null), new ParamType.NonArrayType(){

            @Override
            protected Class<? extends TupleGeneratorBase> parse(String str) {
                try {
                    Class<?> ret = Class.forName(str);
                    Checks.checktest(TupleGeneratorBase.class.isAssignableFrom(ret), "'%s' isn't a sub class of '%s'", ret.getClass(), TupleGeneratorBase.class);
                    return ret;
                }
                catch (ClassNotFoundException e) {
                    Checks.checktest(false, "The class '%s' you specified as a tuple generator was not found in the class path.", str);
                    assert (false);
                    return null;
                }
            }
        }.withDefaultValue(IPO2TupleGenerator.class), new ParamType(){

            @Override
            public Object parse(final String[] values) {
                return new Param(){

                    @Override
                    public String[] value() {
                        return values;
                    }

                    @Override
                    public Class<? extends Annotation> annotationType() {
                        return Param.class;
                    }
                };
            }

            @Override
            public boolean isVarArgs() {
                return true;
            }
        }};
    }

    private static interface FoundTupleObserver {
        public void found(File var1);
    }

    public static enum ReplayMode {
        All{

            @Override
            public boolean shouldBeReplayed(File testStoreDir) {
                return true;
            }
        }
        ,
        FailedOnly{

            @Override
            public boolean shouldBeReplayed(File testStoreDir) {
                return new File(testStoreDir, "failed").exists();
            }
        };


        public abstract boolean shouldBeReplayed(File var1);
    }

    public static enum GenerationMode {
        Replay{

            @Override
            long initializeTuples(Replayer tupleReplayer, Object[] params) {
                File baseDir = Recorder.testClassDataDirFor((String)params[1], tupleReplayer.getTargetClass());
                final int[] work = new int[]{0};
                File[] tupleDirs = tupleReplayer.getRecordedTupleDirectories((ReplayMode)((Object)params[0]), baseDir, new FoundTupleObserver(){

                    @Override
                    public void found(File f) {
                        work[0] = work[0] + 1;
                    }
                });
                int numFoundTuples = work[0];
                Checks.checktest(tupleDirs != null, "Test hasn't been run with 'JCUnitRecorder' rule yet. No tuple containing directory under '%s' was found.", baseDir);
                tupleReplayer.tuples = new TreeMap();
                for (File dir : tupleDirs) {
                    Tuple tuple = TupleUtils.load(Utils.openForRead(new File(dir, "testcase.ser")));
                    tupleReplayer.tuples.put(tupleReplayer.getIdFromDirName(dir.getName()), tuple);
                }
                return numFoundTuples;
            }

            @Override
            Tuple getTuple(Replayer tuplePlayer, int tupleId) {
                Checks.checkcond(tuplePlayer.tuples.containsKey(tupleId));
                return (Tuple)tuplePlayer.tuples.get(tupleId);
            }

            @Override
            long nextId(Replayer tuplePlayer, long tupleId) {
                Checks.checkcond(tuplePlayer.tuples.containsKey(tupleId));
                Iterator<Long> tail = tuplePlayer.tuples.tailMap(tupleId).keySet().iterator();
                Checks.checkcond(tail.hasNext());
                tail.next();
                if (!tail.hasNext()) {
                    return -1L;
                }
                return tail.next();
            }

            @Override
            long firstId(Replayer tuplePlayer) {
                if (tuplePlayer.tuples.size() == 0) {
                    return -1L;
                }
                return (Long)tuplePlayer.tuples.firstKey();
            }
        }
        ,
        Fallback{

            @Override
            long initializeTuples(Replayer tupleReplayer, Object[] params) {
                try {
                    tupleReplayer.fallbackGenerator = (TupleGeneratorBase)((Class)params[2]).newInstance();
                }
                catch (InstantiationException e) {
                    Checks.rethrowpluginerror(e, "The class '%s' cannot be instantiated.", params[2]);
                }
                catch (IllegalAccessException e) {
                    Checks.rethrowpluginerror(e, "A no-parameter constructor of '%s' is too less open. Make it public.", params[2]);
                }
                Param[] paramsToFallbackGenerator = params.length >= 4 ? (Param[])Arrays.copyOfRange(params, 3, params.length, Param[].class) : new Param[]{};
                TupleGeneratorBase generator = tupleReplayer.fallbackGenerator;
                generator.setFactors(tupleReplayer.getFactors());
                generator.setConstraintManager(tupleReplayer.getConstraintManager());
                generator.setTargetClass(tupleReplayer.getTargetClass());
                generator.init(ParamType.processParams(generator.parameterTypes(), paramsToFallbackGenerator));
                return generator.size();
            }

            @Override
            Tuple getTuple(Replayer tuplePlayer, int tupleId) {
                return tuplePlayer.fallbackGenerator.getTuple(tupleId);
            }

            @Override
            long nextId(Replayer tuplePlayer, long tupleId) {
                return tuplePlayer.fallbackGenerator.nextId(tupleId);
            }

            @Override
            long firstId(Replayer tuplePlayer) {
                return tuplePlayer.fallbackGenerator.firstId();
            }
        };


        abstract long initializeTuples(Replayer var1, Object[] var2);

        abstract Tuple getTuple(Replayer var1, int var2);

        abstract long nextId(Replayer var1, long var2);

        abstract long firstId(Replayer var1);
    }
}

