/*
 * Decompiled with CFR 0.152.
 */
package com.github.dakusui.jcunit.generators;

import com.github.dakusui.jcunit.core.Checks;
import com.github.dakusui.jcunit.core.ParamType;
import com.github.dakusui.jcunit.core.Utils;
import com.github.dakusui.jcunit.core.factor.Factor;
import com.github.dakusui.jcunit.core.factor.Factors;
import com.github.dakusui.jcunit.core.tuples.Tuple;
import com.github.dakusui.jcunit.generators.TupleGeneratorBase;
import com.github.dakusui.jcunit.generators.ipo2.IPO2;
import com.github.dakusui.jcunit.generators.ipo2.optimizers.GreedyIPO2Optimizer;
import java.util.List;

public class IPO2TupleGenerator
extends TupleGeneratorBase {
    List<Tuple> tests;

    @Override
    public Tuple getTuple(int tupleId) {
        return this.tests.get(tupleId);
    }

    @Override
    protected long initializeTuples(Object[] processedParameters) {
        int strength = ((Number)processedParameters[0]).intValue();
        Factors factors = this.getFactors();
        Checks.checktest(factors.size() >= 2, "There must be 2 or more factors, but only %d (%s) given.", factors.size(), Utils.join(",", new Utils.Formatter<Factor>(){

            @Override
            public String format(Factor elem) {
                return elem.name;
            }
        }, factors.asFactorList().toArray(new Factor[factors.size()])));
        Checks.checktest(factors.size() >= strength, "The strength must be greater than 1 and less than %d, but %d was given.", factors.size(), strength);
        Checks.checktest(strength >= 2, "The strength must be greater than 1 and less than %d, but %d was given.", factors.size(), strength);
        IPO2 ipo2 = new IPO2(this.getFactors(), strength, this.getConstraintManager(), new GreedyIPO2Optimizer());
        this.getConstraintManager().addObserver(ipo2);
        ipo2.ipo();
        this.tests = ipo2.getResult();
        return this.tests.size();
    }

    @Override
    public ParamType[] parameterTypes() {
        return new ParamType[]{ParamType.Int.withDefaultValue(2)};
    }
}

