/*
 * Decompiled with CFR 0.152.
 */
package com.github.dakusui.jcunit.fsm;

import com.github.dakusui.jcunit.core.Checks;
import com.github.dakusui.jcunit.core.FactorField;
import com.github.dakusui.jcunit.core.Utils;
import com.github.dakusui.jcunit.exceptions.JCUnitException;
import com.github.dakusui.jcunit.fsm.FSMLevelsProvider;
import com.github.dakusui.jcunit.fsm.ScenarioSequence;
import com.github.dakusui.jcunit.fsm.Story;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class FSMUtils {
    private FSMUtils() {
    }

    public static <T> void resetStories(final T context) {
        for (Story each : Utils.transform(FSMUtils.getStoryFields(Checks.checknotnull(context)), new Utils.Form<Field, Story>(){

            @Override
            public Story apply(Field in) {
                try {
                    return (Story)in.get(context);
                }
                catch (IllegalAccessException e) {
                    Checks.checkcond(false, "This code shouldn't be executed, because the field is already validated.", new Object[0]);
                    return Checks.checknotnull(null);
                }
            }
        })) {
            each.reset();
        }
    }

    public static <T, SUT> void performStory(T context, String fsmName, SUT sut) {
        FSMUtils.performStory(context, fsmName, sut, ScenarioSequence.Observer.Factory.ForSimple.INSTANCE);
    }

    public static <T, SUT> void performStory(T context, String fsmName, SUT sut, ScenarioSequence.Observer.Factory observerFactory) {
        Checks.checktest(context != null, "Context mustn't be null. Simply give your test object.", new Object[0]);
        Checks.checktest(fsmName != null, "fsmName mustn't be null. Give factor field name whose type is Story<SPEC,SUT> of your test object.", new Object[0]);
        Checks.checktest(sut != null, "SUT mustn't be null. Give your object to be tested.", new Object[0]);
        Checks.checktest(observerFactory != null, "", new Object[0]);
        Field storyField = FSMUtils.lookupStoryField(context, fsmName);
        Checks.checktest(storyField != null, "The field '%s' was not found or not public in the context '%s'", fsmName, context);
        Utils.validateFactorField(storyField).check();
        FSMUtils.resetStories(context);
        try {
            Story story = (Story)storyField.get(context);
            Checks.checktest(story != null, "story parameter must not be null.", new Object[0]);
            Story.Performer.Default.INSTANCE.perform(story, context, sut, Synchronizer.DUMMY, observerFactory.createObserver(fsmName));
        }
        catch (IllegalAccessException e) {
            Checks.rethrow(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void performStoriesConcurrently(final T context, Story.Request[] stories) {
        Checks.checktest(context != null, "Context mustn't be null. Simply give your test object.", new Object[0]);
        Checks.checktest(stories != null, "Stories mustn't be null. Give factor field name whose type is Story<SPEC,SUT> of your test object.", new Object[0]);
        for (String eachFSMmName : Utils.transform(Arrays.asList(stories), new Utils.Form<Story.Request, String>(){

            @Override
            public String apply(Story.Request in) {
                return in.fsmName;
            }
        })) {
            Field storyField = FSMUtils.lookupStoryField(context, eachFSMmName);
            Checks.checktest(storyField != null, "The field '%s' was not found or not public in the context '%s'", eachFSMmName, context);
            Utils.validateFactorField(storyField).check();
        }
        FSMUtils.resetStories(context);
        ExecutorService executorService = Executors.newFixedThreadPool(stories.length);
        try {
            final Synchronizer synchronizer = new Synchronizer.Builder(Utils.transform(Arrays.asList(stories), new Utils.Form<Story.Request, Synchronizable>(){

                @Override
                public Story apply(Story.Request in) {
                    try {
                        return (Story)Checks.checknotnull(FSMUtils.lookupStoryField(context, in.fsmName)).get(context);
                    }
                    catch (IllegalAccessException e) {
                        Checks.rethrow(e);
                        throw new RuntimeException();
                    }
                }
            })).build();
            List<Callable<Boolean>> callables = Utils.transform(Arrays.asList(stories), new Utils.Form<Story.Request, Callable<Boolean>>(){

                @Override
                public Callable apply(Story.Request in) {
                    return in.createCallable(Story.Performer.Default.INSTANCE, synchronizer, context);
                }
            });
            for (Future<Boolean> f : executorService.invokeAll(callables)) {
                Assert.assertThat((Object)f.get(), (Matcher)CoreMatchers.is((Object)true));
            }
        }
        catch (InterruptedException e) {
            Checks.rethrow(e);
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            try {
                throw t;
            }
            catch (JCUnitException ee) {
                throw ee;
            }
            catch (RuntimeException ee) {
                throw ee;
            }
            catch (Error ee) {
                throw ee;
            }
            catch (Throwable ee) {
                Checks.rethrow(ee);
            }
        }
        finally {
            executorService.shutdown();
        }
    }

    public static boolean isStoryField(Field f) {
        Utils.validateFactorField(Checks.checknotnull(f)).check();
        return FSMLevelsProvider.class.isAssignableFrom(f.getAnnotation(FactorField.class).levelsProvider());
    }

    private static <T> List<Field> getStoryFields(T context) {
        LinkedList<Field> ret = new LinkedList<Field>();
        for (Field each : Utils.getAnnotatedFields(context.getClass(), FactorField.class)) {
            if (!FSMUtils.isStoryField(each)) continue;
            ret.add(each);
        }
        return ret;
    }

    public static <T> Field lookupStoryField(T context, String fsmName) {
        try {
            return context.getClass().getField(fsmName);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public static interface Synchronizer {
        public static final Synchronizer DUMMY = new Synchronizer(){

            @Override
            public Synchronizer finishAndSynchronize(Synchronizable task) {
                return this;
            }

            @Override
            public void unregister(Synchronizable task) {
            }
        };

        public Synchronizer finishAndSynchronize(Synchronizable var1);

        public void unregister(Synchronizable var1);

        public static class Builder {
            public final List<Synchronizable> tasks;

            Builder(List<Synchronizable> tasks) {
                this.tasks = Utils.dedup((Iterable)Checks.checknotnull(tasks));
            }

            Synchronizer build() {
                return new Base(Utils.dedup((Iterable)Checks.checknotnull(this.tasks)));
            }
        }

        public static class Base
        implements Synchronizer {
            private final Set<Synchronizable> tasks = new HashSet<Synchronizable>();
            private final Set<Synchronizable> allTasks;
            private Synchronizer next;

            public Base(Collection<? extends Synchronizable> tasks) {
                this.tasks.addAll(Checks.checknotnull(tasks));
                this.allTasks = new LinkedHashSet<Synchronizable>(this.tasks);
            }

            synchronized void finish(Synchronizable task) {
                this.tasks.remove(task);
                this.notifyAll();
            }

            synchronized Synchronizer synchronize() {
                while (!this.checkIfTasksAreAllDone()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.next == null) {
                    this.next = new Base(this.allTasks);
                }
                return this.next;
            }

            @Override
            public Synchronizer finishAndSynchronize(Synchronizable task) {
                this.finish(Checks.checknotnull(task));
                return this.synchronize();
            }

            @Override
            public synchronized void unregister(Synchronizable task) {
                Synchronizer cur = this;
                while (cur != null) {
                    cur.finish(task);
                    cur = cur.next;
                }
            }

            private boolean checkIfTasksAreAllDone() {
                return this.tasks.isEmpty();
            }
        }
    }

    public static interface Synchronizable {
    }
}

