/*
 * Decompiled with CFR 0.152.
 */
package com.github.dakusui.jcunit.core.tuples;

import com.github.dakusui.jcunit.core.Checks;
import com.github.dakusui.jcunit.core.factor.Factor;
import com.github.dakusui.jcunit.core.factor.Factors;
import com.github.dakusui.jcunit.core.tuples.Tuple;
import com.github.dakusui.jcunit.core.tuples.TupleUtils;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class Tuples {
    private final Set<Tuple> tuples;
    private final String factorName;
    private final int strength;

    public Tuples(Factors factors, Factor factorName, int strength) {
        Checks.checknotnull(factors);
        Checks.checknotnull(factorName);
        Checks.checkcond(!factors.contains(factorName), "factors(%s) mustn't contain '%s'", factors.getFactorNames(), factorName.name);
        this.factorName = factorName.name;
        this.strength = strength;
        this.tuples = this.init(factors, factorName);
    }

    private Tuples(Tuples tuples) {
        this.tuples = Collections.unmodifiableSet(tuples.tuples);
        this.factorName = tuples.factorName;
        this.strength = tuples.strength;
    }

    protected Set<Tuple> init(Factors factors, Factor factor) {
        LinkedHashSet<Tuple> ret = new LinkedHashSet<Tuple>();
        for (Tuple t : factors.generateAllPossibleTuples(this.strength - 1)) {
            for (Object l : factor) {
                Tuple tt = t.cloneTuple();
                tt.put(factor.name, l);
                ret.add(tt);
            }
        }
        return ret;
    }

    public void add(Tuple tuple) {
        this.tuples.add(tuple);
    }

    public void removeAll(Set<Tuple> tuples) {
        this.tuples.removeAll(tuples);
    }

    public boolean isEmpty() {
        return this.tuples.isEmpty();
    }

    public List<Tuple> leftTuples() {
        return new LinkedList<Tuple>(this.tuples);
    }

    public Set<Tuple> coveredBy(Tuple tuple) {
        LinkedHashSet<Tuple> ret = new LinkedHashSet<Tuple>();
        Set<Tuple> possibleTuples = TupleUtils.subtuplesOf(tuple, this.strength);
        for (Tuple c : possibleTuples) {
            if (!this.tuples.contains(c)) continue;
            ret.add(c);
        }
        return ret;
    }

    public int hashCode() {
        return this.factorName.hashCode();
    }

    public boolean equals(Object anotherObject) {
        if (!(anotherObject instanceof Tuples)) {
            return false;
        }
        Tuples another = (Tuples)anotherObject;
        return this.factorName.equals(((Tuples)anotherObject).factorName) && ((Object)this.tuples).equals(another.tuples);
    }

    public void addAll(Set<Tuple> leftOver) {
        this.tuples.addAll(leftOver);
    }

    public boolean contains(Tuple tuple) {
        return this.tuples.contains(tuple);
    }

    public Tuples unmodifiableVersion() {
        return new Tuples(this);
    }
}

