/*
 * Decompiled with CFR 0.152.
 */
package com.github.dakusui.jcunit.core.rules;

import com.github.dakusui.jcunit.core.Checks;
import com.github.dakusui.jcunit.core.JCUnit;
import com.github.dakusui.jcunit.core.SystemProperties;
import com.github.dakusui.jcunit.core.Utils;
import com.github.dakusui.jcunit.core.rules.JCUnitRule;
import java.io.File;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.LinkedList;
import org.junit.runner.Description;

public class Recorder
extends JCUnitRule {
    public static final String TESTCASE_FILENAME = "testcase.ser";
    public static final String EXCEPTION_FILENAME = "exception.ser";
    public static final String FAILED_FILENAME = "failed";
    private final String baseDir;
    private boolean initialized = false;
    private File testDataDir;

    public Recorder() {
        this(SystemProperties.jcunitBaseDir().getAbsolutePath());
    }

    public Recorder(String baseDir) {
        this.baseDir = baseDir;
    }

    protected static File testDataDirFor(String baseDir, int id, Description d) {
        return new File(Recorder.testCaseDataDirFor(baseDir, id, d.getTestClass()), d.getMethodName());
    }

    protected static File testCaseDataDirFor(String baseDir, int id, Class<?> testClass) {
        return new File(Recorder.testClassDataDirFor(baseDir, testClass), String.format("data-%d", id));
    }

    public static File testClassDataDirFor(String baseDir, Class<?> testClass) {
        Checks.checknotnull(testClass);
        File parentDir = baseDir == null ? SystemProperties.jcunitBaseDir() : new File(baseDir);
        return new File(parentDir, testClass.getCanonicalName());
    }

    protected void setTestDataDir(File dir) {
        Checks.checknotnull(dir);
        this.testDataDir = dir;
    }

    public static void initializeTestClassDataDir(Class<?> testClass) {
        Recorder.initializeTestClassDataDir(null, testClass);
    }

    public static void initializeTestClassDataDir(String baseDir, Class<?> testClass) {
        if (SystemProperties.isRecorderEnabled()) {
            Checks.checknotnull(testClass);
            File testClassBaseDir = Recorder.testClassDataDirFor(baseDir, testClass);
            if (testClassBaseDir.exists()) {
                Utils.deleteRecursive(testClassBaseDir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    protected void starting(Description d) {
        super.starting(d);
        if (SystemProperties.isRecorderEnabled() && this.getTestCaseType() == JCUnit.TestCaseType.Generated) {
            this.setTestDataDir(Recorder.testDataDirFor(this.baseDir, this.getId(), d));
            Class<Recorder> clazz = Recorder.class;
            // MONITORENTER : com.github.dakusui.jcunit.core.rules.Recorder.class
            if (this.testDataDir.exists()) {
                Utils.deleteRecursive(this.testDataDir);
            }
            boolean dirCreated = this.testDataDir.mkdirs();
            Checks.checkcond(dirCreated);
            Utils.save((Object)this.getTestCase(), new File(this.testDataDir.getParentFile(), TESTCASE_FILENAME));
            // MONITOREXIT : clazz
        }
        this.initialized = true;
    }

    protected void failed(Throwable t, Description d) {
        Checks.checkcond(this.initialized);
        if (SystemProperties.isRecorderEnabled() && this.getTestCaseType() == JCUnit.TestCaseType.Generated) {
            Checks.checkcond(this.testDataDir != null);
            Utils.save((Object)t, new File(this.testDataDir, EXCEPTION_FILENAME));
            Utils.createFile(new File(this.testDataDir.getParentFile(), FAILED_FILENAME));
        }
        super.failed(t, d);
    }

    public <T> void save(T obj) {
        Checks.checkcond(this.initialized);
        if (SystemProperties.isRecorderEnabled() && this.getTestCaseType() == JCUnit.TestCaseType.Generated) {
            for (Field f : Utils.getAnnotatedFields(obj.getClass(), Record.class)) {
                try {
                    Utils.save(f.get(obj), new File(this.testDataDir, f.getName()));
                }
                catch (IllegalAccessException e) {
                    Checks.checkcond(false, "Something went wrong.", new Object[0]);
                }
            }
        }
    }

    public <T> T load() {
        Checks.checkcond(this.initialized);
        T ret = null;
        LinkedList<String> fieldsNotFoundInStore = new LinkedList<String>();
        if (SystemProperties.isRecorderEnabled() && this.getTestCaseType() == JCUnit.TestCaseType.Generated) {
            try {
                ret = (T)this.getTestClass().newInstance();
                for (Field f : Utils.getAnnotatedFields(this.getTestClass(), Record.class)) {
                    File file = new File(this.testDataDir, f.getName());
                    if (!file.exists()) {
                        fieldsNotFoundInStore.add(f.getName());
                        continue;
                    }
                    Utils.setFieldValue(ret, f, Utils.load(file));
                }
            }
            catch (InstantiationException e) {
                Checks.rethrow(e, "Failed to instantiate test class '%s'", this.getTestClass().getCanonicalName());
            }
            catch (IllegalAccessException e) {
                Checks.rethrow(e, "Failed to access non-parameter constructor of test class '%s'", this.getTestClass().getCanonicalName());
            }
        }
        Checks.checkcond(fieldsNotFoundInStore.isEmpty(), "%s: These field(s) are not stored. Maybe you should set system property '%s' true and re-run this test.", fieldsNotFoundInStore, SystemProperties.KEY.RECORDER.key());
        return ret;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Record {
    }
}

