/*
 * Decompiled with CFR 0.152.
 */
package com.github.dakusui.enumerator;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public interface Domains<T, U> {
    public List<T> getDomainNames();

    public List<U> getDomain(T var1);

    public static class Builder<T, U> {
        private LinkedHashMap<T, List<U>> map = new LinkedHashMap();

        public Builder addDomain(T key, U ... values) {
            this.map.put(key, Arrays.asList(values));
            return this;
        }

        public Domains<T, U> build() {
            DomainsImpl ret = new DomainsImpl();
            for (T k : this.map.keySet()) {
                ret.put(k, this.map.get(k));
            }
            return ret;
        }
    }

    public static class DomainsImpl<T, U>
    extends LinkedHashMap<T, List<U>>
    implements Domains<T, U> {
        @Override
        public List<T> getDomainNames() {
            return new LinkedList(this.keySet());
        }

        @Override
        public List<U> getDomain(T domainName) {
            return Collections.unmodifiableList((List)this.get(domainName));
        }
    }
}

