/*
 * Decompiled with CFR 0.152.
 */
package com.github.dactiv.showcase.web.account;

import com.github.dactiv.orm.core.Page;
import com.github.dactiv.orm.core.PageRequest;
import com.github.dactiv.orm.core.PropertyFilters;
import com.github.dactiv.showcase.common.SystemVariableUtils;
import com.github.dactiv.showcase.common.annotation.OperatingAudit;
import com.github.dactiv.showcase.common.enumeration.entity.GroupType;
import com.github.dactiv.showcase.common.enumeration.entity.State;
import com.github.dactiv.showcase.entity.account.User;
import com.github.dactiv.showcase.service.account.AccountManager;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@OperatingAudit(value="\u7528\u6237\u7ba1\u7406")
@RequestMapping(value={"/account/user"})
public class UserController {
    @Autowired
    private AccountManager accountManager;

    @RequestMapping(value={"view"})
    public Page<User> view(PageRequest pageRequest, HttpServletRequest request) {
        List filters = PropertyFilters.build((HttpServletRequest)request, (boolean)true);
        request.setAttribute("states", (Object)SystemVariableUtils.getVariables(State.class, (Object[])new Object[]{3}));
        if (!pageRequest.isOrderBySetted()) {
            pageRequest.setOrderBy("id");
            pageRequest.setOrderDir("desc");
        }
        return this.accountManager.searchUserPage(pageRequest, filters);
    }

    @RequestMapping(value={"insert"})
    @OperatingAudit(function="\u521b\u5efa\u7528\u6237")
    public String insert(User entity, @RequestParam(required=false) List<String> groupId, RedirectAttributes redirectAttributes) {
        entity.setGroupsList(this.accountManager.getGroups(groupId));
        this.accountManager.insertUser(entity);
        redirectAttributes.addFlashAttribute("success", (Object)"\u65b0\u589e\u6210\u529f");
        return "redirect:/account/user/view";
    }

    @RequestMapping(value={"delete"})
    @OperatingAudit(function="\u5220\u9664\u7528\u6237")
    public String delete(@RequestParam(value="ids") List<String> ids, RedirectAttributes redirectAttributes) {
        this.accountManager.deleteUsers(ids);
        redirectAttributes.addFlashAttribute("success", (Object)("\u5220\u9664" + ids.size() + "\u6761\u4fe1\u606f\u6210\u529f"));
        return "redirect:/account/user/view";
    }

    @RequestMapping(value={"update"})
    @OperatingAudit(function="\u66f4\u65b0\u7528\u6237")
    public String update(@ModelAttribute(value="entity") User entity, @RequestParam(required=false) List<String> groupId, RedirectAttributes redirectAttributes) {
        entity.setGroupsList(this.accountManager.getGroups(groupId));
        this.accountManager.updateUser(entity);
        redirectAttributes.addFlashAttribute("success", (Object)"\u4fee\u6539\u6210\u529f");
        return "redirect:/account/user/view";
    }

    @ResponseBody
    @RequestMapping(value={"is-username-unique"})
    public String isUsernameUnique(String username) {
        return String.valueOf(this.accountManager.isUsernameUnique(username));
    }

    @RequestMapping(value={"read"})
    public String read(@RequestParam(value="id", required=false) String id, Model model) {
        List data = null;
        data = SystemVariableUtils.getVariables(State.class, (Object[])new Object[]{3});
        model.addAttribute("states", (Object)data);
        model.addAttribute("groupsList", (Object)this.accountManager.getGroup(GroupType.RoleGorup, new String[0]));
        if (StringUtils.isEmpty((CharSequence)id)) {
            return "account/user/create";
        }
        return "account/user/read";
    }

    @ModelAttribute(value="entity")
    public User bindingModel(@RequestParam(value="id", required=false) String id) {
        User user = new User();
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            user = this.accountManager.getUser(id);
        }
        return user;
    }
}

