/*
 * Decompiled with CFR 0.152.
 */
package com.github.dactiv.showcase.service.foundation;

import com.github.dactiv.orm.core.Page;
import com.github.dactiv.orm.core.PageRequest;
import com.github.dactiv.orm.core.PropertyFilter;
import com.github.dactiv.showcase.common.enumeration.SystemDictionaryCode;
import com.github.dactiv.showcase.dao.foundation.variable.DataDictionaryDao;
import com.github.dactiv.showcase.dao.foundation.variable.DictionaryCategoryDao;
import com.github.dactiv.showcase.entity.foundation.variable.DataDictionary;
import com.github.dactiv.showcase.entity.foundation.variable.DictionaryCategory;
import java.io.Serializable;
import java.util.List;
import org.hibernate.criterion.Order;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SystemVariableManager {
    @Autowired
    private DataDictionaryDao dataDictionaryDao;
    @Autowired
    private DictionaryCategoryDao dictionaryCategoryDao;

    public DataDictionary getDataDictionary(String id) {
        return (DataDictionary)this.dataDictionaryDao.load((Serializable)((Object)id));
    }

    public void saveDataDictionary(DataDictionary entity) {
        this.dataDictionaryDao.save((Object)entity);
    }

    public void deleteDataDictionary(List<String> ids) {
        this.dataDictionaryDao.deleteAll(ids);
    }

    public Page<DataDictionary> searchDataDictionaryPage(PageRequest request, List<PropertyFilter> filters) {
        return this.dataDictionaryDao.findPage(request, filters);
    }

    @Cacheable(value={"findByCateGoryCode"}, key="#code.getCode() + '-' + T(org.apache.commons.lang3.StringUtils).join(#ignoreValue, '-')")
    public List<DataDictionary> getDataDictionariesByCategoryCode(SystemDictionaryCode code, String ... ignoreValue) {
        return this.dataDictionaryDao.getByCategoryCode(code, ignoreValue);
    }

    public DictionaryCategory getDictionaryCategory(String id) {
        return (DictionaryCategory)this.dictionaryCategoryDao.load((Serializable)((Object)id));
    }

    public void saveDictionaryCategory(DictionaryCategory entity) {
        this.dictionaryCategoryDao.save((Object)entity);
    }

    public void deleteDictionaryCategory(List<String> ids) {
        this.dictionaryCategoryDao.deleteAll(ids);
    }

    public Page<DictionaryCategory> searchDictionaryCategoryPage(PageRequest request, List<PropertyFilter> filters) {
        return this.dictionaryCategoryDao.findPage(request, filters);
    }

    public List<DictionaryCategory> getDictionaryCategories() {
        return this.dictionaryCategoryDao.getAll(new Order[0]);
    }

    public List<DictionaryCategory> getDictionaryCategories(List<PropertyFilter> filters) {
        return this.dictionaryCategoryDao.findByPropertyFilter(filters, new Order[0]);
    }
}

