/*
 * Decompiled with CFR 0.152.
 */
package com.github.dactiv.showcase.service.account;

import com.github.dactiv.common.utils.CollectionUtils;
import com.github.dactiv.showcase.common.SessionVariable;
import com.github.dactiv.showcase.common.enumeration.entity.ResourceType;
import com.github.dactiv.showcase.entity.account.Group;
import com.github.dactiv.showcase.entity.account.Resource;
import com.github.dactiv.showcase.service.account.AccountManager;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public abstract class AuthorizationRealm
extends AuthorizingRealm {
    @Autowired
    private AccountManager accountManager;
    private List<String> defaultPermission = Lists.newArrayList();
    private List<String> defaultRole = Lists.newArrayList();

    public void setDefaultPermissionString(String defaultPermissionString) {
        Object[] perms = StringUtils.split((String)defaultPermissionString, (String)",");
        CollectionUtils.addAll((Collection)this.defaultPermission, (Object[])perms);
    }

    public void setDefaultRoleString(String defaultRoleString) {
        Object[] roles = StringUtils.split((String)defaultRoleString, (String)",");
        CollectionUtils.addAll((Collection)this.defaultRole, (Object[])roles);
    }

    public void setDefaultPermission(List<String> defaultPermission) {
        this.defaultPermission = defaultPermission;
    }

    public void setDefaultRole(List<String> defaultRole) {
        this.defaultRole = defaultRole;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
        SessionVariable model = (SessionVariable)principals.getPrimaryPrincipal();
        Assert.notNull((Object)model, (String)"\u627e\u4e0d\u5230principals\u4e2d\u7684SessionVariable");
        String id = model.getUser().getId();
        List authorizationInfo = this.accountManager.getUserResources(id);
        List groupsList = this.accountManager.getUserGroups(id);
        List resourcesList = this.accountManager.mergeResourcesToParent(authorizationInfo, ResourceType.Security);
        model.setAuthorizationInfo(authorizationInfo);
        model.setGroupsList(groupsList);
        model.setMenusList(resourcesList);
        this.addPermissions(info, authorizationInfo);
        this.addRoles(info, groupsList);
        return info;
    }

    private void addRoles(SimpleAuthorizationInfo info, List<Group> groupsList) {
        List temp = CollectionUtils.extractToList(groupsList, (String)"role", (boolean)true);
        List roles = this.getValue(temp, "roles\\[(.*?)\\]");
        if (CollectionUtils.isNotEmpty((Collection)this.defaultRole)) {
            CollectionUtils.addAll((Collection)roles, this.defaultRole.iterator());
        }
        info.addRoles((Collection)roles);
    }

    private void addPermissions(SimpleAuthorizationInfo info, List<Resource> authorizationInfo) {
        List temp = CollectionUtils.extractToList(authorizationInfo, (String)"permission", (boolean)true);
        List permissions = this.getValue(temp, "perms\\[(.*?)\\]");
        if (CollectionUtils.isNotEmpty((Collection)this.defaultPermission)) {
            CollectionUtils.addAll((Collection)permissions, this.defaultPermission.iterator());
        }
        info.addStringPermissions((Collection)permissions);
    }

    private List<String> getValue(List<String> obj, String regex) {
        ArrayList<String> result = new ArrayList<String>();
        if (CollectionUtils.isEmpty(obj)) {
            return result;
        }
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(StringUtils.join(obj, (String)","));
        while (matcher.find()) {
            result.add(matcher.group(1));
        }
        return result;
    }
}

