/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.bd1;

import com.daxie.basis.vector.Vector;
import com.daxie.basis.vector.VectorFunctions;
import com.daxie.log.LogFile;
import com.daxie.tool.ExceptionFunctions;
import com.daxie.tool.FilenameFunctions;
import com.daxie.xops.bd1.BD1Block;
import com.daxie.xops.bd1.BD1Face;
import com.daxie.xops.bd1.BD1Functions;
import de.javagl.obj.Mtl;
import de.javagl.obj.MtlWriter;
import de.javagl.obj.Mtls;
import de.javagl.obj.Obj;
import de.javagl.obj.ObjWriter;
import de.javagl.obj.Objs;
import de.javagl.obj.ReadableObj;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class BD1OBJWriter {
    private boolean data_prepared_flag = false;
    private Map<Integer, String> texture_filenames_map;
    private Map<Integer, List<BD1Face>> faces_map;

    public BD1OBJWriter(Map<Integer, String> texture_filenames_map, List<BD1Block> blocks) {
        if (texture_filenames_map == null || blocks == null) {
            LogFile.WriteWarn((String)"[BD1OBJWriter-<init>] Null argument(s) where non-null required.", (boolean)true);
            return;
        }
        this.texture_filenames_map = texture_filenames_map;
        this.faces_map = new HashMap<Integer, List<BD1Face>>();
        for (BD1Block block : blocks) {
            int i;
            int[] texture_ids = block.GetTextureIDs();
            Vector[] vertex_positions = block.GetVertexPositions();
            float[] us = block.GetUs();
            float[] vs = block.GetVs();
            Vector[] normals = new Vector[6];
            for (int i2 = 0; i2 < 6; ++i2) {
                int[] vertex_indices = BD1Functions.GetFaceCorrespondingVertexIndices(i2);
                Vector v1 = VectorFunctions.VSub((Vector)vertex_positions[vertex_indices[3]], (Vector)vertex_positions[vertex_indices[0]]);
                Vector v2 = VectorFunctions.VSub((Vector)vertex_positions[vertex_indices[1]], (Vector)vertex_positions[vertex_indices[0]]);
                normals[i2] = VectorFunctions.VCross((Vector)v1, (Vector)v2);
                normals[i2] = VectorFunctions.VNorm((Vector)normals[i2]);
            }
            BD1Face[] faces = new BD1Face[6];
            for (i = 0; i < 6; ++i) {
                faces[i] = new BD1Face();
            }
            for (i = 0; i < 6; ++i) {
                int[] vertex_indices = BD1Functions.GetFaceCorrespondingVertexIndices(i);
                int[] uv_indices = BD1Functions.GetFaceCorrespondingUVIndices(i);
                for (int j = 0; j < 4; ++j) {
                    faces[i].SetVertexPosition(j, vertex_positions[vertex_indices[j]]);
                    faces[i].SetUV(j, us[uv_indices[j]], vs[uv_indices[j]]);
                }
                faces[i].SetNormal(normals[i]);
            }
            for (i = 0; i < 6; ++i) {
                int texture_id = texture_ids[i];
                if (!this.faces_map.containsKey(texture_id)) {
                    ArrayList list_temp = new ArrayList();
                    this.faces_map.put(texture_id, list_temp);
                }
                List<BD1Face> faces_list = this.faces_map.get(texture_id);
                faces_list.add(faces[i]);
            }
        }
        this.data_prepared_flag = true;
    }

    public int Write(String obj_filename) {
        String str;
        if (!this.data_prepared_flag) {
            LogFile.WriteWarn((String)"[BD1OBJWriter-Write] Data not prepared.", (boolean)true);
            return -1;
        }
        String mtllib_str = FilenameFunctions.GetFilenameWithoutDirectory((String)obj_filename);
        mtllib_str = FilenameFunctions.GetFilenameWithoutExtension((String)mtllib_str) + ".mtl";
        String mtl_filename = FilenameFunctions.GetFilenameWithoutExtension((String)obj_filename);
        mtl_filename = mtl_filename + ".mtl";
        Obj obj = Objs.create();
        ArrayList<Mtl> mtls = new ArrayList<Mtl>();
        obj.setMtlFileNames(Arrays.asList(mtllib_str));
        obj.setActiveGroupNames(Arrays.asList("map"));
        int count = 0;
        for (Map.Entry<Integer, List<BD1Face>> entry : this.faces_map.entrySet()) {
            int texture_id = entry.getKey();
            String texture_filename = this.texture_filenames_map.get(texture_id);
            if (texture_filename == null) {
                LogFile.WriteWarn((String)("[BD1OBJWriter-Write] Detected a discrepancy between two maps. texture_id:" + texture_id), (boolean)true);
                texture_filename = "unknown_" + texture_id;
            }
            String material_name = FilenameFunctions.GetFilenameWithoutDirectory((String)texture_filename);
            material_name = FilenameFunctions.GetFilenameWithoutExtension((String)material_name);
            material_name = material_name + "_" + texture_id;
            Mtl mtl = Mtls.create((String)material_name);
            mtl.setNs(0.0f);
            mtl.setKa(1.0f, 1.0f, 1.0f);
            mtl.setKd(1.0f, 1.0f, 1.0f);
            mtl.setKs(0.0f, 0.0f, 0.0f);
            mtl.setD(1.0f);
            mtl.setNs(0.0f);
            mtl.setMapKd(texture_filename);
            mtls.add(mtl);
            obj.setActiveMaterialGroupName(material_name);
            List<BD1Face> faces = entry.getValue();
            for (BD1Face face : faces) {
                Vector[] vertex_positions = face.GetVertexPositions();
                Vector normal = face.GetNormal();
                float[] us = face.GetUs();
                float[] vs = face.GetVs();
                for (int i = 3; i >= 0; --i) {
                    obj.addVertex(vertex_positions[i].GetX(), vertex_positions[i].GetY(), vertex_positions[i].GetZ());
                    obj.addNormal(normal.GetX(), normal.GetY(), normal.GetZ());
                    obj.addTexCoord(us[i], -vs[i]);
                }
                int[] indices = new int[]{count, count + 1, count + 2, count + 3};
                obj.addFace(indices, indices, indices);
                count += 4;
            }
        }
        FileOutputStream os_obj = null;
        FileOutputStream os_mtl = null;
        try {
            os_obj = new FileOutputStream(obj_filename);
            os_mtl = new FileOutputStream(mtl_filename);
        }
        catch (IOException e) {
            str = ExceptionFunctions.GetPrintStackTraceString((Throwable)e);
            LogFile.WriteWarn((String)"[BD1OBJWriter-Write] Below is the stack trace.", (boolean)true);
            LogFile.WriteWarn((String)str, (boolean)false);
            return -1;
        }
        try {
            ObjWriter.write((ReadableObj)obj, (OutputStream)os_obj);
            MtlWriter.write(mtls, (OutputStream)os_mtl);
        }
        catch (IOException e) {
            str = ExceptionFunctions.GetPrintStackTraceString((Throwable)e);
            LogFile.WriteWarn((String)"[BD1OBJWriter-Write] Below is the stack trace.", (boolean)true);
            LogFile.WriteWarn((String)str, (boolean)false);
            return -1;
        }
        return 0;
    }
}

