/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.openxops;

import com.daxie.log.LogFile;
import com.daxie.tool.StringFunctions;
import com.daxie.xops.character.CharacterAILevel;
import com.daxie.xops.character.CharacterData;
import com.daxie.xops.character.CharacterTextureType;
import com.daxie.xops.openxops.CharacterSpecifierConverter;
import java.util.List;

public class CharacterDataCodeOutputter {
    private List<CharacterData> character_data_list;

    public CharacterDataCodeOutputter(List<CharacterData> character_data_list) {
        this.character_data_list = character_data_list;
    }

    public String GetCharacterDataSourceCode() {
        String ret = "";
        if (this.character_data_list == null) {
            LogFile.WriteWarn((String)"[OutputCharacterDataSourceCode-GetCharacterDataSourceCode] Data is null.", (boolean)true);
            return ret;
        }
        String array_name = "Human";
        String separator = System.getProperty("line.separator");
        for (int i = 0; i < this.character_data_list.size(); ++i) {
            CharacterData character_data = this.character_data_list.get(i);
            CharacterTextureType xops_texture_type = character_data.GetTextureType();
            CharacterAILevel xops_ai_level = character_data.GetAILevel();
            int openxops_texture_id = CharacterSpecifierConverter.GetOpenXOPSTextureIDFromXOPSTextureType(xops_texture_type);
            int openxops_ai_level = CharacterSpecifierConverter.GetOpenXOPSAILevelFromXOPSAILevel(xops_ai_level);
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Human", (int)i, (String)"texture", (int)openxops_texture_id) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Human", (int)i, (String)"model", (int)character_data.GetModelType().ordinal()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Human", (int)i, (String)"hp", (int)character_data.GetHP()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Human", (int)i, (String)"AIlevel", (int)openxops_ai_level) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Human", (int)i, (String)"Weapon[0]", (int)character_data.GetWeaponID(0)) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Human", (int)i, (String)"Weapon[1]", (int)character_data.GetWeaponID(1)) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Human", (int)i, (String)"type", (int)character_data.GetType().ordinal()) + separator;
        }
        return ret;
    }
}

