/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.mif;

import com.daxie.log.LogFile;
import com.daxie.xops.mif.MIFParser;
import com.daxie.xops.mif.MIFWriter;
import com.daxie.xops.mif.MissionInfo;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;

public class MIFManipulator {
    private MissionInfo mission_info;

    public MIFManipulator(String mif_filename, String encoding) throws FileNotFoundException, UnsupportedEncodingException, NumberFormatException {
        MIFParser mif_parser = new MIFParser(mif_filename, encoding);
        this.mission_info = mif_parser.GetMissionInfo();
    }

    public MIFManipulator() {
        this.mission_info = new MissionInfo();
    }

    public void SetMissionInfo(MissionInfo mission_info) {
        if (mission_info == null) {
            LogFile.WriteWarn((String)"[MIFManipulator-SetMissionInfo] Null argument where non-null required.", (boolean)true);
            return;
        }
        this.mission_info = mission_info;
    }

    public MissionInfo GetMissionInfo() {
        return new MissionInfo(this.mission_info);
    }

    public void Write(String mif_filename, String encoding) throws FileNotFoundException, UnsupportedEncodingException {
        MIFWriter mif_writer = new MIFWriter(this.mission_info);
        mif_writer.Write(mif_filename, encoding);
    }
}

