/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.addon;

import com.daxie.log.LogFile;
import com.daxie.tool.HashFunctions;
import java.io.FileNotFoundException;
import java.security.NoSuchAlgorithmException;

public class AddonHashCalculator {
    private String algorithm;
    private String bd1_hash;
    private String pd1_hash;
    private String mif_hash;
    private String combined_hash;

    public AddonHashCalculator(String algorithm) {
        this.algorithm = algorithm;
        this.bd1_hash = "";
        this.pd1_hash = "";
        this.mif_hash = "";
        this.combined_hash = "";
    }

    public int CalculateBD1Hash(String bd1_filename) {
        try {
            this.bd1_hash = HashFunctions.GetFileHash((String)bd1_filename, (String)this.algorithm);
        }
        catch (FileNotFoundException e) {
            LogFile.WriteWarn((String)("[AddonHashCalculator-CalculateBD1Hash] File not found. filename:" + bd1_filename), (boolean)true);
            return -1;
        }
        catch (NoSuchAlgorithmException e) {
            LogFile.WriteWarn((String)("[AddonHashCalculator-CalculateBD1Hash] No such algorithm. algorithm:" + this.algorithm), (boolean)true);
            return -1;
        }
        return 0;
    }

    public int CalculatePD1Hash(String pd1_filename) {
        try {
            this.pd1_hash = HashFunctions.GetFileHash((String)pd1_filename, (String)this.algorithm);
        }
        catch (FileNotFoundException e) {
            LogFile.WriteWarn((String)("[AddonHashCalculator-CalculatePD1Hash] File not found. filename:" + pd1_filename), (boolean)true);
            return -1;
        }
        catch (NoSuchAlgorithmException e) {
            LogFile.WriteWarn((String)("[AddonHashCalculator-CalculatePD1Hash] No such algorithm. algorithm:" + this.algorithm), (boolean)true);
            return -1;
        }
        return 0;
    }

    public int CalculateMIFHash(String mif_filename) {
        try {
            this.mif_hash = HashFunctions.GetFileHash((String)mif_filename, (String)this.algorithm);
        }
        catch (FileNotFoundException e) {
            LogFile.WriteWarn((String)("[AddonHashCalculator-CalculateMIFHash] File not found. filename:" + mif_filename), (boolean)true);
            return -1;
        }
        catch (NoSuchAlgorithmException e) {
            LogFile.WriteWarn((String)("[AddonHashCalculator-CalculateMIFHash] No such algorithm. algorithm:" + this.algorithm), (boolean)true);
            return -1;
        }
        return 0;
    }

    public int CalculateCombinedHash() {
        boolean hash_not_calculated_flag = false;
        if (this.bd1_hash.equals("")) {
            LogFile.WriteWarn((String)"[AddonHashCalculator-CalculateCombinedHash] BD1 hash not calculated yet.", (boolean)true);
            hash_not_calculated_flag = true;
        }
        if (this.pd1_hash.equals("")) {
            LogFile.WriteWarn((String)"[AddonHashCalculator-CalculateCombinedHash] PD1 hash not calculated yet.", (boolean)true);
            hash_not_calculated_flag = true;
        }
        if (this.mif_hash.equals("")) {
            LogFile.WriteWarn((String)"[AddonHashCalculator-CalculateCombinedHash] MIF hash not calculated yet.", (boolean)true);
            hash_not_calculated_flag = true;
        }
        if (hash_not_calculated_flag) {
            return -1;
        }
        String str = this.bd1_hash + this.pd1_hash + this.mif_hash;
        try {
            this.combined_hash = HashFunctions.GetHash((String)str, (String)this.algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            return -1;
        }
        return 0;
    }

    public String GetBD1Hash() {
        return this.bd1_hash;
    }

    public String GetPD1Hash() {
        return this.pd1_hash;
    }

    public String GetMIFHash() {
        return this.mif_hash;
    }

    public String GetCombinedHash() {
        return this.combined_hash;
    }
}

