/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.pd1;

import com.daxie.basis.vector.Vector;
import com.daxie.basis.vector.VectorFunctions;
import com.daxie.log.LogFile;
import com.daxie.xops.pd1.PD1Manipulator;
import com.daxie.xops.pd1.PD1Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PD1Creator {
    private int point_count = 0;
    private Map<Integer, PD1Point> points_map = new HashMap<Integer, PD1Point>();

    public Set<Integer> GetPointHandles() {
        return new HashSet<Integer>(this.points_map.keySet());
    }

    public int AddPoint(PD1Point point) {
        if (point == null) {
            LogFile.WriteError("[PD1Creator-AddPoint] Null argument where non-null required.");
            return -1;
        }
        int point_handle = this.point_count++;
        this.points_map.put(point_handle, point);
        return point_handle;
    }

    public int DuplicatePoint(int point_handle) {
        if (!this.points_map.containsKey(point_handle)) {
            LogFile.WriteError("[PD1Creator-DuplicatePoint] No such point. handle:" + point_handle);
            return -1;
        }
        PD1Point orig_point = this.points_map.get(point_handle);
        PD1Point duplicated_point = new PD1Point(orig_point);
        int duplicated_point_handle = this.point_count++;
        this.points_map.put(duplicated_point_handle, duplicated_point);
        return point_handle;
    }

    public int CreatePoint(Vector position, float rotation, int parameter_1, int parameter_2, int parameter_3, int parameter_4) {
        PD1Point point = new PD1Point();
        point.SetPosition(position);
        point.SetRotation(rotation);
        point.SetParameter(0, parameter_1);
        point.SetParameter(1, parameter_2);
        point.SetParameter(2, parameter_3);
        point.SetParameter(3, parameter_4);
        int point_handle = this.point_count++;
        this.points_map.put(point_handle, point);
        return point_handle;
    }

    public int SetPointPosition(int point_handle, Vector position) {
        if (!this.points_map.containsKey(point_handle)) {
            LogFile.WriteError("[PD1Creator-SetPointPosition] No such point. handle:" + point_handle);
            return -1;
        }
        PD1Point point = this.points_map.get(point_handle);
        point.SetPosition(position);
        return 0;
    }

    public int SetPointRotation(int point_handle, float rotation) {
        if (!this.points_map.containsKey(point_handle)) {
            LogFile.WriteError("[PD1Creator-SetPointRotation] No such point. handle:" + point_handle);
            return -1;
        }
        PD1Point point = this.points_map.get(point_handle);
        point.SetRotation(rotation);
        return 0;
    }

    public int SetPointParameters(int point_handle, int parameter_1, int parameter_2, int parameter_3, int parameter_4) {
        if (!this.points_map.containsKey(point_handle)) {
            LogFile.WriteError("[PD1Creator-SetPointParameters] No such point. handle:" + point_handle);
            return -1;
        }
        PD1Point point = this.points_map.get(point_handle);
        point.SetParameter(0, parameter_1);
        point.SetParameter(1, parameter_2);
        point.SetParameter(2, parameter_3);
        point.SetParameter(3, parameter_4);
        return 0;
    }

    public int RemovePoint(int point_handle) {
        if (!this.points_map.containsKey(point_handle)) {
            LogFile.WriteError("[PD1Creator-RemovePoint] No such point. handle:" + point_handle);
            return -1;
        }
        this.points_map.remove(point_handle);
        return 0;
    }

    public int Write(String pd1_filename, float offset_y) {
        PD1Manipulator pd1_manipulator = new PD1Manipulator();
        ArrayList<PD1Point> points = new ArrayList<PD1Point>();
        for (PD1Point point : this.points_map.values()) {
            points.add(point);
        }
        pd1_manipulator.SetPoints(points);
        pd1_manipulator.Translate(VectorFunctions.VGet(0.0f, offset_y, 0.0f));
        int ret = pd1_manipulator.Write(pd1_filename);
        return ret;
    }
}

