/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.ids;

import com.daxie.basis.vector.Vector;
import com.daxie.log.LogFile;
import com.daxie.tool.ByteFunctions;
import com.daxie.tool.ExceptionFunctions;
import com.daxie.xops.weapon.WeaponBinSpecifierAndEnumConverter;
import com.daxie.xops.weapon.WeaponData;
import com.daxie.xops.weapon.WeaponModelFilenamesStock;
import com.daxie.xops.weapon.WeaponModelType;
import com.daxie.xops.weapon.WeaponScopeMode;
import com.daxie.xops.weapon.WeaponShootingStance;
import com.daxie.xops.weapon.WeaponTextureFilenamesStock;
import com.daxie.xops.weapon.WeaponTextureType;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;

class IDSParser {
    private WeaponData weapon_data;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDSParser(String ids_filename) throws FileNotFoundException {
        ArrayList<Byte> bin;
        block22: {
            String str;
            this.weapon_data = null;
            bin = new ArrayList<Byte>();
            DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(ids_filename)));
            this.weapon_data = new WeaponData();
            try {
                while (true) {
                    byte read_byte = dis.readByte();
                    bin.add(read_byte);
                }
            }
            catch (EOFException read_byte) {
                try {
                    if (dis != null) {
                        dis.close();
                    }
                }
                catch (IOException e) {
                    str = ExceptionFunctions.GetPrintStackTraceString(e);
                    LogFile.WriteFatal("[IDSParser-<init>] Below is the stack trace.");
                    LogFile.WriteLine(str);
                    LogFile.CloseLogFile();
                    System.exit(1);
                }
            }
            catch (IOException e) {
                try {
                    str = ExceptionFunctions.GetPrintStackTraceString(e);
                    LogFile.WriteFatal("[IDSParser-<init>] Below is the stack trace.");
                    LogFile.WriteLine(str);
                    LogFile.CloseLogFile();
                    System.exit(1);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (dis != null) {
                            dis.close();
                        }
                    }
                    catch (IOException e2) {
                        str = ExceptionFunctions.GetPrintStackTraceString(e2);
                        LogFile.WriteFatal("[IDSParser-<init>] Below is the stack trace.");
                        LogFile.WriteLine(str);
                        LogFile.CloseLogFile();
                        System.exit(1);
                    }
                }
            }
            if (bin.size() == 84) break block22;
            LogFile.WriteError("[IDSParser-<init>] Invalid file size. filename:" + ids_filename);
            return;
        }
        byte[] b = new byte[2];
        int count = 10;
        b[0] = (Byte)bin.get(count);
        b[1] = (Byte)bin.get(count + 1);
        short itemp = ByteFunctions.byte_to_short_le(b);
        this.weapon_data.SetAttackPower(itemp);
        b[0] = (Byte)bin.get(count += 2);
        b[1] = (Byte)bin.get(count + 1);
        itemp = ByteFunctions.byte_to_short_le(b);
        this.weapon_data.SetPenetration(itemp);
        b[0] = (Byte)bin.get(count += 2);
        b[1] = (Byte)bin.get(count + 1);
        itemp = ByteFunctions.byte_to_short_le(b);
        this.weapon_data.SetFiringInterval(itemp);
        b[0] = (Byte)bin.get(count += 2);
        b[1] = (Byte)bin.get(count + 1);
        itemp = ByteFunctions.byte_to_short_le(b);
        this.weapon_data.SetBulletSpeed(itemp);
        b[0] = (Byte)bin.get(count += 2);
        b[1] = (Byte)bin.get(count + 1);
        itemp = ByteFunctions.byte_to_short_le(b);
        this.weapon_data.SetNumberOfBullets(itemp);
        b[0] = (Byte)bin.get(count += 2);
        b[1] = (Byte)bin.get(count + 1);
        itemp = ByteFunctions.byte_to_short_le(b);
        this.weapon_data.SetReloadingTime(itemp);
        b[0] = (Byte)bin.get(count += 2);
        b[1] = (Byte)bin.get(count + 1);
        itemp = ByteFunctions.byte_to_short_le(b);
        this.weapon_data.SetRecoil(itemp);
        b[0] = (Byte)bin.get(count += 2);
        b[1] = (Byte)bin.get(count + 1);
        itemp = ByteFunctions.byte_to_short_le(b);
        this.weapon_data.SetErrorRangeMin(itemp);
        b[0] = (Byte)bin.get(count += 2);
        b[1] = (Byte)bin.get(count + 1);
        itemp = ByteFunctions.byte_to_short_le(b);
        this.weapon_data.SetErrorRangeMax(itemp);
        Vector vtemp = new Vector();
        b[0] = (Byte)bin.get(count += 2);
        b[1] = (Byte)bin.get(count + 1);
        itemp = ByteFunctions.byte_to_short_le(b);
        vtemp.SetX(itemp);
        b[0] = (Byte)bin.get(count += 2);
        b[1] = (Byte)bin.get(count + 1);
        itemp = ByteFunctions.byte_to_short_le(b);
        vtemp.SetY(itemp);
        b[0] = (Byte)bin.get(count += 2);
        b[1] = (Byte)bin.get(count + 1);
        itemp = ByteFunctions.byte_to_short_le(b);
        vtemp.SetZ(itemp);
        this.weapon_data.SetPosition(vtemp);
        vtemp = new Vector();
        b[0] = (Byte)bin.get(count += 2);
        b[1] = (Byte)bin.get(count + 1);
        itemp = ByteFunctions.byte_to_short_le(b);
        vtemp.SetX(itemp);
        b[0] = (Byte)bin.get(count += 2);
        b[1] = (Byte)bin.get(count + 1);
        itemp = ByteFunctions.byte_to_short_le(b);
        vtemp.SetY(itemp);
        b[0] = (Byte)bin.get(count += 2);
        b[1] = (Byte)bin.get(count + 1);
        itemp = ByteFunctions.byte_to_short_le(b);
        vtemp.SetZ(itemp);
        this.weapon_data.SetFlashPosition(vtemp);
        vtemp = new Vector();
        b[0] = (Byte)bin.get(count += 2);
        b[1] = (Byte)bin.get(count + 1);
        itemp = ByteFunctions.byte_to_short_le(b);
        vtemp.SetX(itemp);
        b[0] = (Byte)bin.get(count += 2);
        b[1] = (Byte)bin.get(count + 1);
        itemp = ByteFunctions.byte_to_short_le(b);
        vtemp.SetY(itemp);
        b[0] = (Byte)bin.get(count += 2);
        b[1] = (Byte)bin.get(count + 1);
        itemp = ByteFunctions.byte_to_short_le(b);
        vtemp.SetZ(itemp);
        this.weapon_data.SetCartridgePosition(vtemp);
        b[0] = (Byte)bin.get(count += 2);
        b[1] = (Byte)bin.get(count + 1);
        itemp = ByteFunctions.byte_to_short_le(b);
        WeaponShootingStance shooting_stance = WeaponBinSpecifierAndEnumConverter.GetWeaponShootingStanceFromBinSpecifier(itemp);
        this.weapon_data.SetShootingStance(shooting_stance);
        b[0] = (Byte)bin.get(count += 2);
        b[1] = (Byte)bin.get(count + 1);
        itemp = ByteFunctions.byte_to_short_le(b);
        if (itemp == 0) {
            this.weapon_data.SetRapidFireEnabledFlag(true);
        } else {
            this.weapon_data.SetRapidFireEnabledFlag(false);
        }
        b[0] = (Byte)bin.get(count += 2);
        b[1] = (Byte)bin.get(count + 1);
        itemp = ByteFunctions.byte_to_short_le(b);
        WeaponScopeMode scope_mode = WeaponBinSpecifierAndEnumConverter.GetWeaponScopeModeFromBinSpecifier(itemp);
        this.weapon_data.SetScopeMode(scope_mode);
        b[0] = (Byte)bin.get(count += 2);
        b[1] = (Byte)bin.get(count + 1);
        itemp = ByteFunctions.byte_to_short_le(b);
        WeaponTextureType texture_type = WeaponBinSpecifierAndEnumConverter.GetWeaponTextureTypeFromBinSpecifier(itemp);
        String texture_filename = WeaponTextureFilenamesStock.GetTextureFilename(texture_type);
        this.weapon_data.SetTextureFilename(texture_filename);
        b[0] = (Byte)bin.get(count += 2);
        b[1] = (Byte)bin.get(count + 1);
        itemp = ByteFunctions.byte_to_short_le(b);
        WeaponModelType model_type = WeaponBinSpecifierAndEnumConverter.GetWeaponModelTypeFromBinSpecifier(itemp);
        String model_filename = WeaponModelFilenamesStock.GetModelFilename(model_type);
        this.weapon_data.SetModelFilename(model_filename);
        b[0] = (Byte)bin.get(count += 2);
        b[1] = (Byte)bin.get(count + 1);
        itemp = ByteFunctions.byte_to_short_le(b);
        this.weapon_data.SetScale((float)itemp * 0.1f);
        vtemp = new Vector();
        b[0] = (Byte)bin.get(count += 2);
        b[1] = (Byte)bin.get(count + 1);
        itemp = ByteFunctions.byte_to_short_le(b);
        vtemp.SetX(itemp);
        b[0] = (Byte)bin.get(count += 2);
        b[1] = (Byte)bin.get(count + 1);
        itemp = ByteFunctions.byte_to_short_le(b);
        vtemp.SetY(itemp);
        vtemp.SetZ(0.0f);
        this.weapon_data.SetCartridgeVelocity(vtemp);
        b[0] = (Byte)bin.get(count += 2);
        b[1] = (Byte)bin.get(count + 1);
        itemp = ByteFunctions.byte_to_short_le(b);
        this.weapon_data.SetSoundID(itemp);
        b[0] = (Byte)bin.get(count += 2);
        b[1] = (Byte)bin.get(count + 1);
        itemp = ByteFunctions.byte_to_short_le(b);
        this.weapon_data.SetSoundVolume(itemp);
        b[0] = (Byte)bin.get(count += 2);
        b[1] = (Byte)bin.get(count + 1);
        itemp = ByteFunctions.byte_to_short_le(b);
        if (itemp == 0) {
            this.weapon_data.SetSuppressorEnabledFlag(false);
        } else {
            this.weapon_data.SetSuppressorEnabledFlag(true);
        }
        count += 2;
        byte[] name_buffer = new byte[16];
        for (int i = 0; i < 15; ++i) {
            name_buffer[i] = (Byte)bin.get(count + i);
        }
        name_buffer[15] = 0;
        String strtemp = new String(name_buffer);
        int first_null_pos = 15;
        for (int i = 0; i < 16; ++i) {
            if (strtemp.charAt(i) != '\u0000') continue;
            first_null_pos = i;
            break;
        }
        strtemp = strtemp.substring(0, first_null_pos);
        this.weapon_data.SetName(strtemp);
        this.weapon_data.SetChangeableWeapon(-1);
    }

    public WeaponData GetWeaponData() {
        return new WeaponData(this.weapon_data);
    }
}

