/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.tool;

import com.daxie.log.LogFile;
import com.daxie.tool.ExceptionFunctions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class FileFunctions {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] GetFileAllLines(String filename, String encoding) throws FileNotFoundException, UnsupportedEncodingException {
        String str;
        StringBuilder sb = new StringBuilder("");
        BufferedReader br = null;
        br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), encoding));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
        }
        catch (IOException e) {
            str = ExceptionFunctions.GetPrintStackTraceString(e);
            LogFile.WriteFatal("[FileFunctions-GetFileAllLines] Below is the stack trace.");
            LogFile.WriteLine(str);
            LogFile.CloseLogFile();
            System.exit(1);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                str = ExceptionFunctions.GetPrintStackTraceString(e);
                LogFile.WriteFatal("[FileFunctions-GetFileAllLines] Below is the stack trace.");
                LogFile.WriteLine(str);
                LogFile.CloseLogFile();
                System.exit(1);
            }
        }
        return sb.toString().split("\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Byte> GetFileAllBin(String filename) throws FileNotFoundException {
        ArrayList<Byte> bin = new ArrayList<Byte>();
        DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(filename)));
        try {
            while (true) {
                byte read_byte = dis.readByte();
                bin.add(read_byte);
            }
        }
        catch (EOFException read_byte) {
            try {
                if (dis != null) {
                    dis.close();
                }
            }
            catch (IOException e) {
                String str = ExceptionFunctions.GetPrintStackTraceString(e);
                LogFile.WriteFatal("[FileFunctions-GetFileAllBin] Below is the stack trace.");
                LogFile.WriteLine(str);
                LogFile.CloseLogFile();
                System.exit(1);
            }
        }
        catch (IOException e) {
            String str;
            try {
                str = ExceptionFunctions.GetPrintStackTraceString(e);
                LogFile.WriteFatal("[FileFunctions-GetFileAllBin] Below is the stack trace.");
                LogFile.WriteLine(str);
                LogFile.CloseLogFile();
                System.exit(1);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    if (dis != null) {
                        dis.close();
                    }
                }
                catch (IOException e2) {
                    str = ExceptionFunctions.GetPrintStackTraceString(e2);
                    LogFile.WriteFatal("[FileFunctions-GetFileAllBin] Below is the stack trace.");
                    LogFile.WriteLine(str);
                    LogFile.CloseLogFile();
                    System.exit(1);
                }
            }
        }
        return bin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void CreateTextFile(String filename, String encoding, List<String> lines) throws FileNotFoundException, UnsupportedEncodingException {
        String str;
        BufferedWriter br = null;
        br = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), encoding));
        try {
            for (String line : lines) {
                br.write(line);
                br.newLine();
            }
            br.flush();
        }
        catch (IOException e) {
            str = ExceptionFunctions.GetPrintStackTraceString(e);
            LogFile.WriteFatal("[FileFunctions-CreateTextFile] Below is the stack trace.");
            LogFile.WriteLine(str);
            LogFile.CloseLogFile();
            System.exit(1);
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                str = ExceptionFunctions.GetPrintStackTraceString(e);
                LogFile.WriteFatal("[FileFunctions-CreateTextFile] Below is the stack trace.");
                LogFile.WriteLine(str);
                LogFile.CloseLogFile();
                System.exit(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void CreateBinFile(String filename, List<Byte> bin) throws FileNotFoundException {
        String str;
        DataOutputStream dos = null;
        dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(filename)));
        try {
            for (Byte b : bin) {
                dos.writeByte(b.byteValue());
            }
        }
        catch (IOException e) {
            str = ExceptionFunctions.GetPrintStackTraceString(e);
            LogFile.WriteFatal("[FileFunctions-CreateBinFile] Below is the stack trace.");
            LogFile.WriteLine(str);
            LogFile.CloseLogFile();
            System.exit(1);
        }
        finally {
            try {
                dos.close();
            }
            catch (IOException e) {
                str = ExceptionFunctions.GetPrintStackTraceString(e);
                LogFile.WriteFatal("[FileFunctions-CreateBinFile] Below is the stack trace.");
                LogFile.WriteLine(str);
                LogFile.CloseLogFile();
                System.exit(1);
            }
        }
    }
}

