/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.pd1;

import com.daxie.log.LogFile;
import com.daxie.tool.ByteFunctions;
import com.daxie.tool.ExceptionFunctions;
import com.daxie.xops.pd1.Point;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class PD1Parser {
    private List<Point> points = new ArrayList<Point>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PD1Parser(String pd1_filename) throws FileNotFoundException {
        String str;
        ArrayList<Byte> bin = new ArrayList<Byte>();
        DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(pd1_filename)));
        try {
            while (true) {
                byte read_byte = dis.readByte();
                bin.add(read_byte);
            }
        }
        catch (EOFException read_byte) {
            try {
                if (dis != null) {
                    dis.close();
                }
            }
            catch (IOException e) {
                str = ExceptionFunctions.GetPrintStackTraceString(e);
                LogFile.WriteFatal("[PD1Parser-<init>] Below is the stack trace.");
                LogFile.WriteLine(str);
                LogFile.CloseLogFile();
                System.exit(1);
            }
        }
        catch (IOException e) {
            try {
                str = ExceptionFunctions.GetPrintStackTraceString(e);
                LogFile.WriteFatal("[PD1Parser-<init>] Below is the stack trace.");
                LogFile.WriteLine(str);
                LogFile.CloseLogFile();
                System.exit(1);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    if (dis != null) {
                        dis.close();
                    }
                }
                catch (IOException e2) {
                    str = ExceptionFunctions.GetPrintStackTraceString(e2);
                    LogFile.WriteFatal("[PD1Parser-<init>] Below is the stack trace.");
                    LogFile.WriteLine(str);
                    LogFile.CloseLogFile();
                    System.exit(1);
                }
            }
        }
        int count = 0;
        byte[] point_num_buffer = new byte[]{(Byte)bin.get(count), (Byte)bin.get(count + 1)};
        int point_num = ByteFunctions.byte_to_ushort_le(point_num_buffer);
        count += 2;
        for (int i = 0; i < point_num; ++i) {
            int j;
            Point point = new Point();
            byte[] byte_buffer = new byte[4];
            for (j = 0; j < 4; ++j) {
                byte_buffer[j] = (Byte)bin.get(count);
                ++count;
            }
            float ftemp = ByteFunctions.byte_to_float_le(byte_buffer);
            point.SetPositionX(ftemp);
            for (j = 0; j < 4; ++j) {
                byte_buffer[j] = (Byte)bin.get(count);
                ++count;
            }
            ftemp = ByteFunctions.byte_to_float_le(byte_buffer);
            point.SetPositionY(ftemp);
            for (j = 0; j < 4; ++j) {
                byte_buffer[j] = (Byte)bin.get(count);
                ++count;
            }
            ftemp = ByteFunctions.byte_to_float_le(byte_buffer);
            point.SetPositionZ(ftemp);
            for (j = 0; j < 4; ++j) {
                byte_buffer[j] = (Byte)bin.get(count);
                ++count;
            }
            ftemp = ByteFunctions.byte_to_float_le(byte_buffer);
            point.SetRotation(ftemp);
            for (int j2 = 0; j2 < 4; ++j2) {
                int itemp = Byte.toUnsignedInt((Byte)bin.get(count));
                ++count;
                point.SetParameter(j2, itemp);
            }
            this.points.add(point);
        }
    }

    public List<Point> GetPoints() {
        return new ArrayList<Point>(this.points);
    }
}

