/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.ids;

import com.daxie.log.LogFile;
import com.daxie.tool.ExceptionFunctions;
import com.daxie.xops.ids.IDSParser;
import com.daxie.xops.ids.IDSWriter;
import com.daxie.xops.weapon.WeaponData;
import java.io.FileNotFoundException;

public class IDSManipulator {
    private WeaponData weapon_data = null;

    public IDSManipulator(String ids_filename) throws FileNotFoundException {
        IDSParser ids_parser = new IDSParser(ids_filename);
        this.weapon_data = ids_parser.GetWeaponData();
    }

    public IDSManipulator() {
    }

    public WeaponData GetWeaponData() {
        if (this.weapon_data == null) {
            return null;
        }
        return new WeaponData(this.weapon_data);
    }

    public void SetWeaponData(WeaponData weapon_data) {
        if (weapon_data == null) {
            LogFile.WriteError("[IDSManipulator-SetWeaponData] Null argument where non-null required.");
            return;
        }
        this.weapon_data = weapon_data;
    }

    public int Write(String ids_filename) {
        IDSWriter ids_writer = new IDSWriter(this.weapon_data);
        try {
            ids_writer.Write(ids_filename);
        }
        catch (FileNotFoundException e) {
            String str = ExceptionFunctions.GetPrintStackTraceString(e);
            LogFile.WriteError("[IDSManipulator-Write] Failed to write data.");
            LogFile.WriteLine("Below is the stack trace.");
            LogFile.WriteLine(str);
            return -1;
        }
        return 0;
    }
}

