/*
 * Decompiled with CFR 0.152.
 */
package com.github.dabasan.xops.properties.openxops;

import com.github.dabasan.tool.FileFunctions;
import com.github.dabasan.tool.StringFunctions;
import com.github.dabasan.xops.properties.entity.character.CharacterAILevel;
import com.github.dabasan.xops.properties.entity.character.CharacterData;
import com.github.dabasan.xops.properties.entity.character.CharacterModelType;
import com.github.dabasan.xops.properties.entity.character.CharacterTextureType;
import com.github.dabasan.xops.properties.entity.character.CharacterType;
import com.github.dabasan.xops.properties.openxops.CharacterSpecifierConverter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharacterDataCodeParser {
    private final Logger logger = LoggerFactory.getLogger(CharacterDataCodeParser.class);
    private Map<Integer, CharacterData> character_data_map = new HashMap<Integer, CharacterData>();

    public CharacterDataCodeParser(List<String> lines) {
        if (lines == null) {
            this.logger.warn("Null argument where non-null required.");
            return;
        }
        this.ParseLines(lines);
    }

    public CharacterDataCodeParser(String code_filename, String encoding) throws IOException {
        List lines = FileFunctions.GetFileAllLines((String)code_filename, (String)encoding);
        this.ParseLines(lines);
    }

    private void ParseLines(List<String> lines) {
        for (int i = 0; i < lines.size(); ++i) {
            CharacterData character_data;
            int index;
            block29: {
                String line = lines.get(i);
                String[] split_by_equal = (line = line.replace(";", "")).split("=");
                if (split_by_equal.length != 2) {
                    this.logger.warn("Syntax error. line:{}", (Object)i);
                    continue;
                }
                String left = split_by_equal[0];
                String[] split_by_dot = left.split(Pattern.quote("."));
                if (split_by_dot.length != 2) {
                    this.logger.warn("Syntax error. line:{}", (Object)i);
                    continue;
                }
                String field_name = split_by_dot[1];
                field_name = field_name.replace(" ", "");
                String array_name_and_index = split_by_dot[0];
                String index_str = StringFunctions.GetFirstStringInBetween((String)array_name_and_index, (char)'[', (char)']');
                index = -1;
                try {
                    index = Integer.parseInt(index_str);
                }
                catch (NumberFormatException e) {
                    this.logger.warn("Invalid index. line:{}", (Object)i);
                    continue;
                }
                if (index < 0) {
                    this.logger.warn("Index must be a number greater than or equal to zero.");
                    continue;
                }
                if (!this.character_data_map.containsKey(index)) {
                    character_data = new CharacterData();
                    this.character_data_map.put(index, character_data);
                }
                character_data = this.character_data_map.get(index);
                String value = split_by_equal[1];
                try {
                    switch (field_name) {
                        case "texture": {
                            value = value.replace(" ", "");
                            int itemp = Integer.parseInt(value);
                            CharacterTextureType texture_type = CharacterSpecifierConverter.GetXOPSTextureTypeFromOpenXOPSTextureID(itemp);
                            character_data.SetTextureType(texture_type);
                            break block29;
                        }
                        case "model": {
                            value = value.replace(" ", "");
                            int itemp = Integer.parseInt(value);
                            CharacterModelType[] model_types = CharacterModelType.values();
                            if (0 > itemp || itemp >= model_types.length) {
                                this.logger.warn("Value out of bounds. line:{}", (Object)i);
                                break;
                            }
                            character_data.SetModelType(model_types[itemp]);
                            break block29;
                        }
                        case "hp": {
                            value = value.replace(" ", "");
                            int itemp = Integer.parseInt(value);
                            character_data.SetHP(itemp);
                            break block29;
                        }
                        case "AIlevel": {
                            value = value.replace(" ", "");
                            int itemp = Integer.parseInt(value);
                            CharacterAILevel ai_level = CharacterSpecifierConverter.GetXOPSAILevelFromOpenXOPSAILevel(itemp);
                            character_data.SetAILevel(ai_level);
                            break block29;
                        }
                        case "Weapon[0]": {
                            value = value.replace(" ", "");
                            int itemp = Integer.parseInt(value);
                            character_data.SetWeaponID(0, itemp);
                            break block29;
                        }
                        case "Weapon[1]": {
                            value = value.replace(" ", "");
                            int itemp = Integer.parseInt(value);
                            character_data.SetWeaponID(1, itemp);
                            break block29;
                        }
                        case "type": {
                            value = value.replace(" ", "");
                            int itemp = Integer.parseInt(value);
                            CharacterType[] types = CharacterType.values();
                            if (0 > itemp || itemp >= types.length) {
                                this.logger.warn("Value out of bounds. line:{}", (Object)i);
                                break;
                            }
                            character_data.SetType(types[itemp]);
                            break block29;
                        }
                        default: {
                            this.logger.warn("Unknown field name. line:{}", (Object)i);
                            break;
                        }
                    }
                }
                catch (NumberFormatException e) {
                    this.logger.warn("Invalid number format. line:{}", (Object)i);
                }
                continue;
            }
            this.character_data_map.put(index, character_data);
        }
    }

    public HashMap<Integer, CharacterData> GetData() {
        return new HashMap<Integer, CharacterData>(this.character_data_map);
    }

    public TreeMap<Integer, CharacterData> GetOrderedData() {
        return new TreeMap<Integer, CharacterData>(this.character_data_map);
    }
}

