/*
 * Decompiled with CFR 0.152.
 */
package com.github.dabasan.xops.properties.xms.xcs;

import com.github.dabasan.xops.properties.entity.character.CharacterData;
import com.github.dabasan.xops.properties.xms.xcs.XCSParser;
import com.github.dabasan.xops.properties.xms.xcs.XCSWriter;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XCSManipulator {
    private final Logger logger = LoggerFactory.getLogger(XCSManipulator.class);
    private CharacterData[] character_data_array;

    public XCSManipulator(String xcs_filename) throws IOException {
        XCSParser xcs_parser = new XCSParser(xcs_filename);
        this.character_data_array = xcs_parser.GetCharacterData();
    }

    public XCSManipulator() {
    }

    public CharacterData[] GetCharacterData() {
        if (this.character_data_array == null) {
            return null;
        }
        CharacterData[] ret = new CharacterData[this.character_data_array.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new CharacterData(this.character_data_array[i]);
        }
        return ret;
    }

    public void SetCharacterData(CharacterData[] character_data_array) {
        if (character_data_array == null) {
            this.logger.warn("Null argument where non-null required.");
            return;
        }
        this.character_data_array = character_data_array;
    }

    public int Write(String xcs_filename) {
        XCSWriter xcs_writer = new XCSWriter(this.character_data_array);
        int ret = xcs_writer.Write(xcs_filename);
        if (ret < 0) {
            this.logger.error("Failed to write data in a XCS file.");
            return -1;
        }
        return 0;
    }
}

