/*
 * Decompiled with CFR 0.152.
 */
package com.github.dabasan.xops.properties.exe;

import com.github.dabasan.tool.FileFunctions;
import com.github.dabasan.xops.properties.exe.XOPSVersion;
import java.io.IOException;
import java.util.List;

public class XOPSExeFunctions {
    public static XOPSVersion GetXOPSVersion(String xops_filename) throws IOException {
        XOPSVersion version = XOPSVersion.UNKNOWN_VERSION;
        List bin = FileFunctions.GetFileAllBin((String)xops_filename);
        int file_size = bin.size();
        if (file_size == 458752) {
            byte[] b = new byte[]{(Byte)bin.get(256), (Byte)bin.get(257), (Byte)bin.get(258)};
            if (b[0] == 183 && b[1] == 191 && b[2] == 84) {
                version = XOPSVersion.XOPS096;
            } else if (b[0] == 151 && b[1] == 123 && b[2] == 170) {
                version = XOPSVersion.XOPS096T;
            }
        } else {
            version = file_size == 462848 ? XOPSVersion.XOPS097FT : (file_size == 552960 ? XOPSVersion.XOPS0975T : (file_size == 495616 ? XOPSVersion.XOPSOLT18F2 : (file_size == 598016 ? XOPSVersion.XOPSOLT19F2 : XOPSVersion.UNKNOWN_VERSION)));
        }
        return version;
    }

    public static XOPSVersion GetXOPSVersion(List<Byte> bin) {
        XOPSVersion version = XOPSVersion.UNKNOWN_VERSION;
        int file_size = bin.size();
        if (file_size == 458752) {
            byte[] b = new byte[3];
            int[] ub = new int[3];
            b[0] = bin.get(256);
            b[1] = bin.get(257);
            b[2] = bin.get(258);
            ub[0] = Byte.toUnsignedInt(b[0]);
            ub[1] = Byte.toUnsignedInt(b[1]);
            ub[2] = Byte.toUnsignedInt(b[2]);
            if (ub[0] == 183 && ub[1] == 191 && ub[2] == 84) {
                version = XOPSVersion.XOPS096;
            } else if (ub[0] == 151 && ub[1] == 123 && ub[2] == 170) {
                version = XOPSVersion.XOPS096T;
            }
        } else {
            version = file_size == 462848 ? XOPSVersion.XOPS097FT : (file_size == 552960 ? XOPSVersion.XOPS0975T : (file_size == 495616 ? XOPSVersion.XOPSOLT18F2 : (file_size == 598016 ? XOPSVersion.XOPSOLT19F2 : XOPSVersion.UNKNOWN_VERSION)));
        }
        return version;
    }
}

