/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.properties.xms.ids;

import com.daxie.basis.vector.Vector;
import com.daxie.log.LogWriter;
import com.daxie.tool.ByteFunctions;
import com.daxie.tool.ExceptionFunctions;
import com.daxie.xops.properties.entity.weapon.WeaponBinSpecifierAndEnumConverter;
import com.daxie.xops.properties.entity.weapon.WeaponData;
import com.daxie.xops.properties.entity.weapon.WeaponModelFilenamesStock;
import com.daxie.xops.properties.entity.weapon.WeaponModelType;
import com.daxie.xops.properties.entity.weapon.WeaponScopeMode;
import com.daxie.xops.properties.entity.weapon.WeaponShootingStance;
import com.daxie.xops.properties.entity.weapon.WeaponTextureFilenamesStock;
import com.daxie.xops.properties.entity.weapon.WeaponTextureType;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

class IDSWriter {
    private WeaponData weapon_data = null;

    public IDSWriter(WeaponData weapon_data) {
        this.weapon_data = weapon_data;
    }

    public void Write(String ids_filename) throws IOException {
        if (this.weapon_data == null) {
            LogWriter.WriteWarn((String)"[IDSWriter-Write] Data is null.", (boolean)true);
            return;
        }
        try (DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(ids_filename)));){
            int i;
            dos.writeByte(73);
            dos.writeByte(68);
            dos.writeByte(83);
            dos.writeByte(0);
            dos.writeByte(1);
            dos.writeByte(0);
            dos.writeByte(10);
            dos.writeByte(0);
            dos.writeByte(29);
            dos.writeByte(0);
            int itemp = this.weapon_data.GetAttackPower();
            byte[] b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            dos.write(b);
            itemp = this.weapon_data.GetPenetration();
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            dos.write(b);
            itemp = this.weapon_data.GetFiringInterval();
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            dos.write(b);
            itemp = this.weapon_data.GetBulletSpeed();
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            dos.write(b);
            itemp = this.weapon_data.GetNumberOfBullets();
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            dos.write(b);
            itemp = this.weapon_data.GetReloadingTime();
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            dos.write(b);
            itemp = this.weapon_data.GetRecoil();
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            dos.write(b);
            itemp = this.weapon_data.GetErrorRangeMin();
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            dos.write(b);
            itemp = this.weapon_data.GetErrorRangeMax();
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            dos.write(b);
            Vector vtemp = this.weapon_data.GetPosition();
            itemp = Math.round(vtemp.GetX());
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            dos.write(b);
            itemp = Math.round(vtemp.GetY());
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            dos.write(b);
            itemp = Math.round(vtemp.GetZ());
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            dos.write(b);
            vtemp = this.weapon_data.GetFlashPosition();
            itemp = Math.round(vtemp.GetX());
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            dos.write(b);
            itemp = Math.round(vtemp.GetY());
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            dos.write(b);
            itemp = Math.round(vtemp.GetZ());
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            dos.write(b);
            vtemp = this.weapon_data.GetCartridgePosition();
            itemp = Math.round(vtemp.GetX());
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            dos.write(b);
            itemp = Math.round(vtemp.GetY());
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            dos.write(b);
            itemp = Math.round(vtemp.GetZ());
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            dos.write(b);
            WeaponShootingStance shooting_stance = this.weapon_data.GetShootingStance();
            itemp = WeaponBinSpecifierAndEnumConverter.GetBinSpecifierFromWeaponShootingStance(shooting_stance);
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            dos.write(b);
            itemp = !this.weapon_data.GetRapidFireEnabledFlag() ? 1 : 0;
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            dos.write(b);
            WeaponScopeMode scope_mode = this.weapon_data.GetScopeMode();
            itemp = WeaponBinSpecifierAndEnumConverter.GetBinSpecifierFromWeaponScopeMode(scope_mode);
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            dos.write(b);
            String texture_filename = this.weapon_data.GetTextureFilename();
            WeaponTextureType texture_type = WeaponTextureFilenamesStock.GetWeaponTextureTypeFromFilename(texture_filename);
            itemp = WeaponBinSpecifierAndEnumConverter.GetBinSpecifierFromWeaponTextureType(texture_type);
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            dos.write(b);
            String model_filename = this.weapon_data.GetModelFilename();
            WeaponModelType model_type = WeaponModelFilenamesStock.GetWeaponModelTypeFromFilename(model_filename);
            itemp = WeaponBinSpecifierAndEnumConverter.GetBinSpecifierFromWeaponModelType(model_type);
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            dos.write(b);
            itemp = Math.round(this.weapon_data.GetScale() * 10.0f);
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            dos.write(b);
            vtemp = this.weapon_data.GetCartridgeVelocity();
            itemp = Math.round(vtemp.GetX());
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            dos.write(b);
            itemp = Math.round(vtemp.GetY());
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            dos.write(b);
            itemp = this.weapon_data.GetSoundID();
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            dos.write(b);
            itemp = this.weapon_data.GetSoundVolume();
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            dos.write(b);
            itemp = !this.weapon_data.GetSuppressorEnabledFlag() ? 0 : 1;
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            dos.write(b);
            String name = this.weapon_data.GetName();
            byte[] name_buffer = new byte[16];
            for (i = 0; i < 16; ++i) {
                name_buffer[i] = 0;
            }
            for (i = 0; i < name.length() && i < 15; ++i) {
                name_buffer[i] = (byte)name.charAt(i);
            }
            dos.write(name_buffer);
        }
        catch (IOException e) {
            String str = ExceptionFunctions.GetPrintStackTraceString((Throwable)e);
            LogWriter.WriteWarn((String)"[IDSWriter-Write] Below is the stack trace.", (boolean)true);
            LogWriter.WriteWarn((String)str, (boolean)false);
            return;
        }
    }
}

