/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.properties.xms.ids;

import com.daxie.log.LogWriter;
import com.daxie.tool.ExceptionFunctions;
import com.daxie.xops.properties.entity.weapon.WeaponData;
import com.daxie.xops.properties.xms.ids.IDSParser;
import com.daxie.xops.properties.xms.ids.IDSWriter;
import java.io.IOException;

public class IDSManipulator {
    private WeaponData weapon_data = null;

    public IDSManipulator(String ids_filename) throws IOException {
        IDSParser ids_parser = new IDSParser(ids_filename);
        this.weapon_data = ids_parser.GetWeaponData();
    }

    public IDSManipulator() {
    }

    public WeaponData GetWeaponData() {
        if (this.weapon_data == null) {
            return null;
        }
        return new WeaponData(this.weapon_data);
    }

    public void SetWeaponData(WeaponData weapon_data) {
        if (weapon_data == null) {
            LogWriter.WriteWarn((String)"[IDSManipulator-SetWeaponData] Null argument where non-null required.", (boolean)true);
            return;
        }
        this.weapon_data = weapon_data;
    }

    public int Write(String ids_filename) {
        IDSWriter ids_writer = new IDSWriter(this.weapon_data);
        try {
            ids_writer.Write(ids_filename);
        }
        catch (IOException e) {
            String str = ExceptionFunctions.GetPrintStackTraceString((Throwable)e);
            LogWriter.WriteWarn((String)"[IDSManipulator-Write] Failed to write data.", (boolean)true);
            LogWriter.WriteWarn((String)"Below is the stack trace.", (boolean)false);
            LogWriter.WriteWarn((String)str, (boolean)false);
            return -1;
        }
        return 0;
    }
}

